// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.serde

import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CollectionDetail
import aws.sdk.kotlin.services.opensearchserverless.model.CollectionErrorDetail
import aws.sdk.kotlin.services.opensearchserverless.model.OpenSearchServerlessException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetCollectionOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetCollectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetCollectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetCollectionError(context, call, payload)
        }
        val builder = BatchGetCollectionResponse.Builder()

        if (payload != null) {
            deserializeBatchGetCollectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetCollectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchServerlessException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetCollectionOperationBody(builder: BatchGetCollectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLECTIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("collectionDetails"))
    val COLLECTIONERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("collectionErrorDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLECTIONDETAILS_DESCRIPTOR)
        field(COLLECTIONERRORDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLECTIONDETAILS_DESCRIPTOR.index -> builder.collectionDetails =
                    deserializer.deserializeList(COLLECTIONDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<CollectionDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCollectionDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                COLLECTIONERRORDETAILS_DESCRIPTOR.index -> builder.collectionErrorDetails =
                    deserializer.deserializeList(COLLECTIONERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<CollectionErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCollectionErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
