// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.paginators

import aws.sdk.kotlin.services.opensearchserverless.OpenSearchServerlessClient
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListLifecyclePoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListLifecyclePoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPoliciesResponse]
 */
public fun OpenSearchServerlessClient.listAccessPoliciesPaginated(initialRequest: ListAccessPoliciesRequest): Flow<ListAccessPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPoliciesPaginated.listAccessPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPoliciesResponse]
 */
public fun OpenSearchServerlessClient.listAccessPoliciesPaginated(block: ListAccessPoliciesRequest.Builder.() -> Unit): Flow<ListAccessPoliciesResponse> =
    listAccessPoliciesPaginated(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCollectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectionsResponse]
 */
public fun OpenSearchServerlessClient.listCollectionsPaginated(initialRequest: ListCollectionsRequest = ListCollectionsRequest { }): Flow<ListCollectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCollectionsPaginated.listCollections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectionsResponse]
 */
public fun OpenSearchServerlessClient.listCollectionsPaginated(block: ListCollectionsRequest.Builder.() -> Unit): Flow<ListCollectionsResponse> =
    listCollectionsPaginated(ListCollectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLifecyclePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLifecyclePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecyclePoliciesResponse]
 */
public fun OpenSearchServerlessClient.listLifecyclePoliciesPaginated(initialRequest: ListLifecyclePoliciesRequest): Flow<ListLifecyclePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLifecyclePoliciesPaginated.listLifecyclePolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLifecyclePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecyclePoliciesResponse]
 */
public fun OpenSearchServerlessClient.listLifecyclePoliciesPaginated(block: ListLifecyclePoliciesRequest.Builder.() -> Unit): Flow<ListLifecyclePoliciesResponse> =
    listLifecyclePoliciesPaginated(ListLifecyclePoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSecurityConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityConfigsResponse]
 */
public fun OpenSearchServerlessClient.listSecurityConfigsPaginated(initialRequest: ListSecurityConfigsRequest): Flow<ListSecurityConfigsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityConfigsPaginated.listSecurityConfigs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityConfigsResponse]
 */
public fun OpenSearchServerlessClient.listSecurityConfigsPaginated(block: ListSecurityConfigsRequest.Builder.() -> Unit): Flow<ListSecurityConfigsResponse> =
    listSecurityConfigsPaginated(ListSecurityConfigsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSecurityPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityPoliciesResponse]
 */
public fun OpenSearchServerlessClient.listSecurityPoliciesPaginated(initialRequest: ListSecurityPoliciesRequest): Flow<ListSecurityPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityPoliciesPaginated.listSecurityPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityPoliciesResponse]
 */
public fun OpenSearchServerlessClient.listSecurityPoliciesPaginated(block: ListSecurityPoliciesRequest.Builder.() -> Unit): Flow<ListSecurityPoliciesResponse> =
    listSecurityPoliciesPaginated(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVpcEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVpcEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcEndpointsResponse]
 */
public fun OpenSearchServerlessClient.listVpcEndpointsPaginated(initialRequest: ListVpcEndpointsRequest = ListVpcEndpointsRequest { }): Flow<ListVpcEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVpcEndpointsPaginated.listVpcEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVpcEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcEndpointsResponse]
 */
public fun OpenSearchServerlessClient.listVpcEndpointsPaginated(block: ListVpcEndpointsRequest.Builder.() -> Unit): Flow<ListVpcEndpointsResponse> =
    listVpcEndpointsPaginated(ListVpcEndpointsRequest.Builder().apply(block).build())
