// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about a security configuration for OpenSearch Serverless.
 */
public class SecurityConfigDetail private constructor(builder: Builder) {
    /**
     * The version of the security configuration.
     */
    public val configVersion: kotlin.String? = builder.configVersion
    /**
     * The date the configuration was created.
     */
    public val createdDate: kotlin.Long? = builder.createdDate
    /**
     * The description of the security configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Describes IAM Identity Center options in the form of a key-value map.
     */
    public val iamIdentityCenterOptions: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterConfigOptions? = builder.iamIdentityCenterOptions
    /**
     * The unique identifier of the security configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The timestamp of when the configuration was last modified.
     */
    public val lastModifiedDate: kotlin.Long? = builder.lastModifiedDate
    /**
     * SAML options for the security configuration in the form of a key-value map.
     */
    public val samlOptions: aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions? = builder.samlOptions
    /**
     * The type of security configuration.
     */
    public val type: aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityConfigDetail(")
        append("configVersion=$configVersion,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("iamIdentityCenterOptions=$iamIdentityCenterOptions,")
        append("id=$id,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("samlOptions=$samlOptions,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configVersion?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iamIdentityCenterOptions?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (samlOptions?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityConfigDetail

        if (configVersion != other.configVersion) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (iamIdentityCenterOptions != other.iamIdentityCenterOptions) return false
        if (id != other.id) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (samlOptions != other.samlOptions) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the security configuration.
         */
        public var configVersion: kotlin.String? = null
        /**
         * The date the configuration was created.
         */
        public var createdDate: kotlin.Long? = null
        /**
         * The description of the security configuration.
         */
        public var description: kotlin.String? = null
        /**
         * Describes IAM Identity Center options in the form of a key-value map.
         */
        public var iamIdentityCenterOptions: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterConfigOptions? = null
        /**
         * The unique identifier of the security configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp of when the configuration was last modified.
         */
        public var lastModifiedDate: kotlin.Long? = null
        /**
         * SAML options for the security configuration in the form of a key-value map.
         */
        public var samlOptions: aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions? = null
        /**
         * The type of security configuration.
         */
        public var type: aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigDetail) : this() {
            this.configVersion = x.configVersion
            this.createdDate = x.createdDate
            this.description = x.description
            this.iamIdentityCenterOptions = x.iamIdentityCenterOptions
            this.id = x.id
            this.lastModifiedDate = x.lastModifiedDate
            this.samlOptions = x.samlOptions
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigDetail = SecurityConfigDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterConfigOptions] inside the given [block]
         */
        public fun iamIdentityCenterOptions(block: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterConfigOptions.Builder.() -> kotlin.Unit) {
            this.iamIdentityCenterOptions = aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterConfigOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions] inside the given [block]
         */
        public fun samlOptions(block: aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions.Builder.() -> kotlin.Unit) {
            this.samlOptions = aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
