// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes SAML options for an OpenSearch Serverless security configuration in the form of a key-value map.
 */
public class SamlConfigOptions private constructor(builder: Builder) {
    /**
     * The group attribute for this SAML integration.
     */
    public val groupAttribute: kotlin.String? = builder.groupAttribute
    /**
     * The XML IdP metadata file generated from your identity provider.
     */
    public val metadata: kotlin.String = requireNotNull(builder.metadata) { "A non-null value must be provided for metadata" }
    /**
     * The session timeout, in minutes. Default is 60 minutes (12 hours).
     */
    public val sessionTimeout: kotlin.Int? = builder.sessionTimeout
    /**
     * A user attribute for this SAML integration.
     */
    public val userAttribute: kotlin.String? = builder.userAttribute

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlConfigOptions(")
        append("groupAttribute=$groupAttribute,")
        append("metadata=$metadata,")
        append("sessionTimeout=$sessionTimeout,")
        append("userAttribute=$userAttribute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupAttribute?.hashCode() ?: 0
        result = 31 * result + (metadata.hashCode())
        result = 31 * result + (sessionTimeout ?: 0)
        result = 31 * result + (userAttribute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlConfigOptions

        if (groupAttribute != other.groupAttribute) return false
        if (metadata != other.metadata) return false
        if (sessionTimeout != other.sessionTimeout) return false
        if (userAttribute != other.userAttribute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The group attribute for this SAML integration.
         */
        public var groupAttribute: kotlin.String? = null
        /**
         * The XML IdP metadata file generated from your identity provider.
         */
        public var metadata: kotlin.String? = null
        /**
         * The session timeout, in minutes. Default is 60 minutes (12 hours).
         */
        public var sessionTimeout: kotlin.Int? = null
        /**
         * A user attribute for this SAML integration.
         */
        public var userAttribute: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions) : this() {
            this.groupAttribute = x.groupAttribute
            this.metadata = x.metadata
            this.sessionTimeout = x.sessionTimeout
            this.userAttribute = x.userAttribute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearchserverless.model.SamlConfigOptions = SamlConfigOptions(this)

        internal fun correctErrors(): Builder {
            if (metadata == null) metadata = ""
            return this
        }
    }
}
