// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes IAM Identity Center options for creating an OpenSearch Serverless security configuration in the form of a key-value map.
 */
public class CreateIamIdentityCenterConfigOptions private constructor(builder: Builder) {
    /**
     * The group attribute for this IAM Identity Center integration. Defaults to `GroupId`.
     */
    public val groupAttribute: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterGroupAttribute? = builder.groupAttribute
    /**
     * The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
     */
    public val instanceArn: kotlin.String = requireNotNull(builder.instanceArn) { "A non-null value must be provided for instanceArn" }
    /**
     * The user attribute for this IAM Identity Center integration. Defaults to `UserId`.
     */
    public val userAttribute: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterUserAttribute? = builder.userAttribute

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearchserverless.model.CreateIamIdentityCenterConfigOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIamIdentityCenterConfigOptions(")
        append("groupAttribute=$groupAttribute,")
        append("instanceArn=$instanceArn,")
        append("userAttribute=$userAttribute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupAttribute?.hashCode() ?: 0
        result = 31 * result + (instanceArn.hashCode())
        result = 31 * result + (userAttribute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIamIdentityCenterConfigOptions

        if (groupAttribute != other.groupAttribute) return false
        if (instanceArn != other.instanceArn) return false
        if (userAttribute != other.userAttribute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearchserverless.model.CreateIamIdentityCenterConfigOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The group attribute for this IAM Identity Center integration. Defaults to `GroupId`.
         */
        public var groupAttribute: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterGroupAttribute? = null
        /**
         * The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The user attribute for this IAM Identity Center integration. Defaults to `UserId`.
         */
        public var userAttribute: aws.sdk.kotlin.services.opensearchserverless.model.IamIdentityCenterUserAttribute? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearchserverless.model.CreateIamIdentityCenterConfigOptions) : this() {
            this.groupAttribute = x.groupAttribute
            this.instanceArn = x.instanceArn
            this.userAttribute = x.userAttribute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearchserverless.model.CreateIamIdentityCenterConfigOptions = CreateIamIdentityCenterConfigOptions(this)

        internal fun correctErrors(): Builder {
            if (instanceArn == null) instanceArn = ""
            return this
        }
    }
}
