// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about each OpenSearch Serverless collection, including the collection endpoint and the OpenSearch Dashboards endpoint.
 */
public class CollectionDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the collection.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.
     */
    public val collectionEndpoint: kotlin.String? = builder.collectionEndpoint
    /**
     * The Epoch time when the collection was created.
     */
    public val createdDate: kotlin.Long? = builder.createdDate
    /**
     * Collection-specific endpoint used to access OpenSearch Dashboards.
     */
    public val dashboardEndpoint: kotlin.String? = builder.dashboardEndpoint
    /**
     * A description of the collection.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A failure code associated with the request.
     */
    public val failureCode: kotlin.String? = builder.failureCode
    /**
     * A message associated with the failure code.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * A unique identifier for the collection.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The ARN of the Amazon Web Services KMS key used to encrypt the collection.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The date and time when the collection was last modified.
     */
    public val lastModifiedDate: kotlin.Long? = builder.lastModifiedDate
    /**
     * The name of the collection.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Details about an OpenSearch Serverless collection.
     */
    public val standbyReplicas: aws.sdk.kotlin.services.opensearchserverless.model.StandbyReplicas? = builder.standbyReplicas
    /**
     * The current status of the collection.
     */
    public val status: aws.sdk.kotlin.services.opensearchserverless.model.CollectionStatus? = builder.status
    /**
     * The type of collection.
     */
    public val type: aws.sdk.kotlin.services.opensearchserverless.model.CollectionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearchserverless.model.CollectionDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollectionDetail(")
        append("arn=$arn,")
        append("collectionEndpoint=$collectionEndpoint,")
        append("createdDate=$createdDate,")
        append("dashboardEndpoint=$dashboardEndpoint,")
        append("description=$description,")
        append("failureCode=$failureCode,")
        append("failureMessage=$failureMessage,")
        append("id=$id,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("name=$name,")
        append("standbyReplicas=$standbyReplicas,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (collectionEndpoint?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (dashboardEndpoint?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (standbyReplicas?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollectionDetail

        if (arn != other.arn) return false
        if (collectionEndpoint != other.collectionEndpoint) return false
        if (createdDate != other.createdDate) return false
        if (dashboardEndpoint != other.dashboardEndpoint) return false
        if (description != other.description) return false
        if (failureCode != other.failureCode) return false
        if (failureMessage != other.failureMessage) return false
        if (id != other.id) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (name != other.name) return false
        if (standbyReplicas != other.standbyReplicas) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearchserverless.model.CollectionDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the collection.
         */
        public var arn: kotlin.String? = null
        /**
         * Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.
         */
        public var collectionEndpoint: kotlin.String? = null
        /**
         * The Epoch time when the collection was created.
         */
        public var createdDate: kotlin.Long? = null
        /**
         * Collection-specific endpoint used to access OpenSearch Dashboards.
         */
        public var dashboardEndpoint: kotlin.String? = null
        /**
         * A description of the collection.
         */
        public var description: kotlin.String? = null
        /**
         * A failure code associated with the request.
         */
        public var failureCode: kotlin.String? = null
        /**
         * A message associated with the failure code.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * A unique identifier for the collection.
         */
        public var id: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services KMS key used to encrypt the collection.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The date and time when the collection was last modified.
         */
        public var lastModifiedDate: kotlin.Long? = null
        /**
         * The name of the collection.
         */
        public var name: kotlin.String? = null
        /**
         * Details about an OpenSearch Serverless collection.
         */
        public var standbyReplicas: aws.sdk.kotlin.services.opensearchserverless.model.StandbyReplicas? = null
        /**
         * The current status of the collection.
         */
        public var status: aws.sdk.kotlin.services.opensearchserverless.model.CollectionStatus? = null
        /**
         * The type of collection.
         */
        public var type: aws.sdk.kotlin.services.opensearchserverless.model.CollectionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearchserverless.model.CollectionDetail) : this() {
            this.arn = x.arn
            this.collectionEndpoint = x.collectionEndpoint
            this.createdDate = x.createdDate
            this.dashboardEndpoint = x.dashboardEndpoint
            this.description = x.description
            this.failureCode = x.failureCode
            this.failureMessage = x.failureMessage
            this.id = x.id
            this.kmsKeyArn = x.kmsKeyArn
            this.lastModifiedDate = x.lastModifiedDate
            this.name = x.name
            this.standbyReplicas = x.standbyReplicas
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearchserverless.model.CollectionDetail = CollectionDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
