// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.opensearchserverless.auth.DefaultOpenSearchServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.opensearchserverless.auth.OpenSearchServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.opensearchserverless.endpoints.DefaultOpenSearchServerlessEndpointProvider
import aws.sdk.kotlin.services.opensearchserverless.endpoints.OpenSearchServerlessEndpointParameters
import aws.sdk.kotlin.services.opensearchserverless.endpoints.OpenSearchServerlessEndpointProvider
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateLifecyclePolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateLifecyclePolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteLifecyclePolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteLifecyclePolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetPoliciesStatsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetPoliciesStatsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListLifecyclePoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListLifecyclePoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.TagResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.TagResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UntagResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UntagResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateLifecyclePolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateLifecyclePolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateVpcEndpointResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "OpenSearchServerless"
public const val SdkVersion: String = "1.3.67"
public const val ServiceApiVersion: String = "2021-11-01"

/**
 * Use the Amazon OpenSearch Serverless API to create, configure, and manage OpenSearch Serverless collections and security policies.
 *
 * OpenSearch Serverless is an on-demand, pre-provisioned serverless configuration for Amazon OpenSearch Service. OpenSearch Serverless removes the operational complexities of provisioning, configuring, and tuning your OpenSearch clusters. It enables you to easily search and analyze petabytes of data without having to worry about the underlying infrastructure and data management.
 *
 *  To learn more about OpenSearch Serverless, see [What is Amazon OpenSearch Serverless?](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html)
 */
public interface OpenSearchServerlessClient : SdkClient {
    /**
     * OpenSearchServerlessClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, OpenSearchServerlessClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "OpenSearchServerless",
                "OPENSEARCHSERVERLESS",
                "opensearchserverless",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, OpenSearchServerlessClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): OpenSearchServerlessClient = DefaultOpenSearchServerlessClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: OpenSearchServerlessEndpointProvider = builder.endpointProvider ?: DefaultOpenSearchServerlessEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: OpenSearchServerlessAuthSchemeProvider = builder.authSchemeProvider ?: DefaultOpenSearchServerlessAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "OpenSearchServerless"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: OpenSearchServerlessEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: OpenSearchServerlessAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun batchGetCollection(input: BatchGetCollectionRequest = BatchGetCollectionRequest { }): BatchGetCollectionResponse

    /**
     * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
     */
    public suspend fun batchGetEffectiveLifecyclePolicy(input: BatchGetEffectiveLifecyclePolicyRequest): BatchGetEffectiveLifecyclePolicyResponse

    /**
     * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
     */
    public suspend fun batchGetLifecyclePolicy(input: BatchGetLifecyclePolicyRequest): BatchGetLifecyclePolicyResponse

    /**
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun batchGetVpcEndpoint(input: BatchGetVpcEndpointRequest): BatchGetVpcEndpointResponse

    /**
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun createAccessPolicy(input: CreateAccessPolicyRequest): CreateAccessPolicyResponse

    /**
     * Creates a new OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun createCollection(input: CreateCollectionRequest): CreateCollectionResponse

    /**
     * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of days or hours to retain the data on an OpenSearch Serverless index. For more information, see [Creating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create).
     */
    public suspend fun createLifecyclePolicy(input: CreateLifecyclePolicyRequest): CreateLifecyclePolicyResponse

    /**
     * Specifies a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun createSecurityConfig(input: CreateSecurityConfigRequest): CreateSecurityConfigResponse

    /**
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun createSecurityPolicy(input: CreateSecurityPolicyRequest): CreateSecurityPolicyResponse

    /**
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse

    /**
     * Deletes an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun deleteAccessPolicy(input: DeleteAccessPolicyRequest): DeleteAccessPolicyResponse

    /**
     * Deletes an OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun deleteCollection(input: DeleteCollectionRequest): DeleteCollectionResponse

    /**
     * Deletes an OpenSearch Serverless lifecycle policy. For more information, see [Deleting data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete).
     */
    public suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Deletes a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun deleteSecurityConfig(input: DeleteSecurityConfigRequest): DeleteSecurityConfigResponse

    /**
     * Deletes an OpenSearch Serverless security policy.
     */
    public suspend fun deleteSecurityPolicy(input: DeleteSecurityPolicyRequest): DeleteSecurityPolicyResponse

    /**
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun deleteVpcEndpoint(input: DeleteVpcEndpointRequest): DeleteVpcEndpointResponse

    /**
     * Returns an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun getAccessPolicy(input: GetAccessPolicyRequest): GetAccessPolicyResponse

    /**
     * Returns account-level settings related to OpenSearch Serverless.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest { }): GetAccountSettingsResponse

    /**
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.
     */
    public suspend fun getPoliciesStats(input: GetPoliciesStatsRequest = GetPoliciesStatsRequest { }): GetPoliciesStatsResponse

    /**
     * Returns information about an OpenSearch Serverless security configuration. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun getSecurityConfig(input: GetSecurityConfigRequest): GetSecurityConfigResponse

    /**
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun getSecurityPolicy(input: GetSecurityPolicyRequest): GetSecurityPolicyResponse

    /**
     * Returns information about a list of OpenSearch Serverless access policies.
     */
    public suspend fun listAccessPolicies(input: ListAccessPoliciesRequest): ListAccessPoliciesResponse

    /**
     * Lists all OpenSearch Serverless collections. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     *
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     */
    public suspend fun listCollections(input: ListCollectionsRequest = ListCollectionsRequest { }): ListCollectionsResponse

    /**
     * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
     */
    public suspend fun listLifecyclePolicies(input: ListLifecyclePoliciesRequest): ListLifecyclePoliciesResponse

    /**
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun listSecurityConfigs(input: ListSecurityConfigsRequest): ListSecurityConfigsResponse

    /**
     * Returns information about configured OpenSearch Serverless security policies.
     */
    public suspend fun listSecurityPolicies(input: ListSecurityPoliciesRequest): ListSecurityPoliciesResponse

    /**
     * Returns the tags for an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun listVpcEndpoints(input: ListVpcEndpointsRequest = ListVpcEndpointsRequest { }): ListVpcEndpointsResponse

    /**
     * Associates tags with an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun updateAccessPolicy(input: UpdateAccessPolicyRequest): UpdateAccessPolicyResponse

    /**
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see [Managing capacity limits for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest { }): UpdateAccountSettingsResponse

    /**
     * Updates an OpenSearch Serverless collection.
     */
    public suspend fun updateCollection(input: UpdateCollectionRequest): UpdateCollectionResponse

    /**
     * Updates an OpenSearch Serverless access policy. For more information, see [Updating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update).
     */
    public suspend fun updateLifecyclePolicy(input: UpdateLifecyclePolicyRequest): UpdateLifecyclePolicyResponse

    /**
     * Updates a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun updateSecurityConfig(input: UpdateSecurityConfigRequest): UpdateSecurityConfigResponse

    /**
     * Updates an OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun updateSecurityPolicy(input: UpdateSecurityPolicyRequest): UpdateSecurityPolicyResponse

    /**
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun updateVpcEndpoint(input: UpdateVpcEndpointRequest): UpdateVpcEndpointResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun OpenSearchServerlessClient.withConfig(block: OpenSearchServerlessClient.Config.Builder.() -> Unit): OpenSearchServerlessClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultOpenSearchServerlessClient(newConfig)
}

/**
 * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetCollection(crossinline block: BatchGetCollectionRequest.Builder.() -> Unit): BatchGetCollectionResponse = batchGetCollection(BatchGetCollectionRequest.Builder().apply(block).build())

/**
 * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetEffectiveLifecyclePolicy(crossinline block: BatchGetEffectiveLifecyclePolicyRequest.Builder.() -> Unit): BatchGetEffectiveLifecyclePolicyResponse = batchGetEffectiveLifecyclePolicy(BatchGetEffectiveLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetLifecyclePolicy(crossinline block: BatchGetLifecyclePolicyRequest.Builder.() -> Unit): BatchGetLifecyclePolicyResponse = batchGetLifecyclePolicy(BatchGetLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetVpcEndpoint(crossinline block: BatchGetVpcEndpointRequest.Builder.() -> Unit): BatchGetVpcEndpointResponse = batchGetVpcEndpoint(BatchGetVpcEndpointRequest.Builder().apply(block).build())

/**
 * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.createAccessPolicy(crossinline block: CreateAccessPolicyRequest.Builder.() -> Unit): CreateAccessPolicyResponse = createAccessPolicy(CreateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Creates a new OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.createCollection(crossinline block: CreateCollectionRequest.Builder.() -> Unit): CreateCollectionResponse = createCollection(CreateCollectionRequest.Builder().apply(block).build())

/**
 * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of days or hours to retain the data on an OpenSearch Serverless index. For more information, see [Creating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create).
 */
public suspend inline fun OpenSearchServerlessClient.createLifecyclePolicy(crossinline block: CreateLifecyclePolicyRequest.Builder.() -> Unit): CreateLifecyclePolicyResponse = createLifecyclePolicy(CreateLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Specifies a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.createSecurityConfig(crossinline block: CreateSecurityConfigRequest.Builder.() -> Unit): CreateSecurityConfigResponse = createSecurityConfig(CreateSecurityConfigRequest.Builder().apply(block).build())

/**
 * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.createSecurityPolicy(crossinline block: CreateSecurityPolicyRequest.Builder.() -> Unit): CreateSecurityPolicyResponse = createSecurityPolicy(CreateSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.createVpcEndpoint(crossinline block: CreateVpcEndpointRequest.Builder.() -> Unit): CreateVpcEndpointResponse = createVpcEndpoint(CreateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteAccessPolicy(crossinline block: DeleteAccessPolicyRequest.Builder.() -> Unit): DeleteAccessPolicyResponse = deleteAccessPolicy(DeleteAccessPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteCollection(crossinline block: DeleteCollectionRequest.Builder.() -> Unit): DeleteCollectionResponse = deleteCollection(DeleteCollectionRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless lifecycle policy. For more information, see [Deleting data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete).
 */
public suspend inline fun OpenSearchServerlessClient.deleteLifecyclePolicy(crossinline block: DeleteLifecyclePolicyRequest.Builder.() -> Unit): DeleteLifecyclePolicyResponse = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteSecurityConfig(crossinline block: DeleteSecurityConfigRequest.Builder.() -> Unit): DeleteSecurityConfigResponse = deleteSecurityConfig(DeleteSecurityConfigRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless security policy.
 */
public suspend inline fun OpenSearchServerlessClient.deleteSecurityPolicy(crossinline block: DeleteSecurityPolicyRequest.Builder.() -> Unit): DeleteSecurityPolicyResponse = deleteSecurityPolicy(DeleteSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteVpcEndpoint(crossinline block: DeleteVpcEndpointRequest.Builder.() -> Unit): DeleteVpcEndpointResponse = deleteVpcEndpoint(DeleteVpcEndpointRequest.Builder().apply(block).build())

/**
 * Returns an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.getAccessPolicy(crossinline block: GetAccessPolicyRequest.Builder.() -> Unit): GetAccessPolicyResponse = getAccessPolicy(GetAccessPolicyRequest.Builder().apply(block).build())

/**
 * Returns account-level settings related to OpenSearch Serverless.
 */
public suspend inline fun OpenSearchServerlessClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.
 */
public suspend inline fun OpenSearchServerlessClient.getPoliciesStats(crossinline block: GetPoliciesStatsRequest.Builder.() -> Unit): GetPoliciesStatsResponse = getPoliciesStats(GetPoliciesStatsRequest.Builder().apply(block).build())

/**
 * Returns information about an OpenSearch Serverless security configuration. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.getSecurityConfig(crossinline block: GetSecurityConfigRequest.Builder.() -> Unit): GetSecurityConfigResponse = getSecurityConfig(GetSecurityConfigRequest.Builder().apply(block).build())

/**
 * Returns information about a configured OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.getSecurityPolicy(crossinline block: GetSecurityPolicyRequest.Builder.() -> Unit): GetSecurityPolicyResponse = getSecurityPolicy(GetSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a list of OpenSearch Serverless access policies.
 */
public suspend inline fun OpenSearchServerlessClient.listAccessPolicies(crossinline block: ListAccessPoliciesRequest.Builder.() -> Unit): ListAccessPoliciesResponse = listAccessPolicies(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Lists all OpenSearch Serverless collections. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 *
 * Make sure to include an empty request body {} if you don't include any collection filters in the request.
 */
public suspend inline fun OpenSearchServerlessClient.listCollections(crossinline block: ListCollectionsRequest.Builder.() -> Unit): ListCollectionsResponse = listCollections(ListCollectionsRequest.Builder().apply(block).build())

/**
 * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
 */
public suspend inline fun OpenSearchServerlessClient.listLifecyclePolicies(crossinline block: ListLifecyclePoliciesRequest.Builder.() -> Unit): ListLifecyclePoliciesResponse = listLifecyclePolicies(ListLifecyclePoliciesRequest.Builder().apply(block).build())

/**
 * Returns information about configured OpenSearch Serverless security configurations. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.listSecurityConfigs(crossinline block: ListSecurityConfigsRequest.Builder.() -> Unit): ListSecurityConfigsResponse = listSecurityConfigs(ListSecurityConfigsRequest.Builder().apply(block).build())

/**
 * Returns information about configured OpenSearch Serverless security policies.
 */
public suspend inline fun OpenSearchServerlessClient.listSecurityPolicies(crossinline block: ListSecurityPoliciesRequest.Builder.() -> Unit): ListSecurityPoliciesResponse = listSecurityPolicies(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * Returns the tags for an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.listVpcEndpoints(crossinline block: ListVpcEndpointsRequest.Builder.() -> Unit): ListVpcEndpointsResponse = listVpcEndpoints(ListVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Associates tags with an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateAccessPolicy(crossinline block: UpdateAccessPolicyRequest.Builder.() -> Unit): UpdateAccessPolicyResponse = updateAccessPolicy(UpdateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see [Managing capacity limits for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless collection.
 */
public suspend inline fun OpenSearchServerlessClient.updateCollection(crossinline block: UpdateCollectionRequest.Builder.() -> Unit): UpdateCollectionResponse = updateCollection(UpdateCollectionRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless access policy. For more information, see [Updating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update).
 */
public suspend inline fun OpenSearchServerlessClient.updateLifecyclePolicy(crossinline block: UpdateLifecyclePolicyRequest.Builder.() -> Unit): UpdateLifecyclePolicyResponse = updateLifecyclePolicy(UpdateLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Updates a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateSecurityConfig(crossinline block: UpdateSecurityConfigRequest.Builder.() -> Unit): UpdateSecurityConfigResponse = updateSecurityConfig(UpdateSecurityConfigRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateSecurityPolicy(crossinline block: UpdateSecurityPolicyRequest.Builder.() -> Unit): UpdateSecurityPolicyResponse = updateSecurityPolicy(UpdateSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateVpcEndpoint(crossinline block: UpdateVpcEndpointRequest.Builder.() -> Unit): UpdateVpcEndpointResponse = updateVpcEndpoint(UpdateVpcEndpointRequest.Builder().apply(block).build())
