// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class UpgradeDomainOperationDeserializer: HttpDeserializer.NonStreaming<UpgradeDomainResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpgradeDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpgradeDomainError(context, call, payload)
        }
        val builder = UpgradeDomainResponse.Builder()

        if (payload != null) {
            deserializeUpgradeDomainOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpgradeDomainError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpgradeDomainOperationBody(builder: UpgradeDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AdvancedOptions"))
    val CHANGEPROGRESSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChangeProgressDetails"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val PERFORMCHECKONLY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformCheckOnly"))
    val TARGETVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetVersion"))
    val UPGRADEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpgradeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDOPTIONS_DESCRIPTOR)
        field(CHANGEPROGRESSDETAILS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(PERFORMCHECKONLY_DESCRIPTOR)
        field(TARGETVERSION_DESCRIPTOR)
        field(UPGRADEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDOPTIONS_DESCRIPTOR.index -> builder.advancedOptions =
                    deserializer.deserializeMap(ADVANCEDOPTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CHANGEPROGRESSDETAILS_DESCRIPTOR.index -> builder.changeProgressDetails = deserializeChangeProgressDetailsDocument(deserializer)
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                PERFORMCHECKONLY_DESCRIPTOR.index -> builder.performCheckOnly = deserializeBoolean()
                TARGETVERSION_DESCRIPTOR.index -> builder.targetVersion = deserializeString()
                UPGRADEID_DESCRIPTOR.index -> builder.upgradeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
