// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.ActionType
import aws.sdk.kotlin.services.opensearch.model.ScheduleAt
import aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateScheduledActionOperationSerializer: HttpSerializer.NonStreaming<UpdateScheduledActionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateScheduledActionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-01-01"))
                add(PercentEncoding.Path.encode("opensearch"))
                add(PercentEncoding.Path.encode("domain"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("scheduledAction"))
                add(PercentEncoding.Path.encode("update"))
            }
        }

        val payload = serializeUpdateScheduledActionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateScheduledActionOperationBody(context: ExecutionContext, input: UpdateScheduledActionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionID"))
    val ACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ActionType"))
    val DESIREDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("DesiredStartTime"))
    val SCHEDULEAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ScheduleAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONID_DESCRIPTOR)
        field(ACTIONTYPE_DESCRIPTOR)
        field(DESIREDSTARTTIME_DESCRIPTOR)
        field(SCHEDULEAT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionId?.let { field(ACTIONID_DESCRIPTOR, it) }
        input.actionType?.let { field(ACTIONTYPE_DESCRIPTOR, it.value) }
        input.desiredStartTime?.let { field(DESIREDSTARTTIME_DESCRIPTOR, it) }
        input.scheduleAt?.let { field(SCHEDULEAT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
