// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput
import aws.sdk.kotlin.services.opensearch.model.AimlOptionsInput
import aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions
import aws.sdk.kotlin.services.opensearch.model.ClusterConfig
import aws.sdk.kotlin.services.opensearch.model.CognitoOptions
import aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions
import aws.sdk.kotlin.services.opensearch.model.DryRunMode
import aws.sdk.kotlin.services.opensearch.model.EbsOptions
import aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions
import aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsInput
import aws.sdk.kotlin.services.opensearch.model.IpAddressType
import aws.sdk.kotlin.services.opensearch.model.LogPublishingOption
import aws.sdk.kotlin.services.opensearch.model.LogType
import aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions
import aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptions
import aws.sdk.kotlin.services.opensearch.model.SnapshotOptions
import aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptions
import aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest
import aws.sdk.kotlin.services.opensearch.model.VpcOptions
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDomainConfigOperationSerializer: HttpSerializer.NonStreaming<UpdateDomainConfigRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDomainConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-01-01"))
                add(PercentEncoding.Path.encode("opensearch"))
                add(PercentEncoding.Path.encode("domain"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("config"))
            }
        }

        val payload = serializeUpdateDomainConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDomainConfigOperationBody(context: ExecutionContext, input: UpdateDomainConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val AIMLOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AIMLOptions"))
    val ACCESSPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessPolicies"))
    val ADVANCEDOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AdvancedOptions"))
    val ADVANCEDSECURITYOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AdvancedSecurityOptions"))
    val AUTOTUNEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoTuneOptions"))
    val CLUSTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ClusterConfig"))
    val COGNITOOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CognitoOptions"))
    val DOMAINENDPOINTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DomainEndpointOptions"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val DRYRUNMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DryRunMode"))
    val EBSOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EBSOptions"))
    val ENCRYPTIONATRESTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionAtRestOptions"))
    val IPADDRESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IPAddressType"))
    val IDENTITYCENTEROPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IdentityCenterOptions"))
    val LOGPUBLISHINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("LogPublishingOptions"))
    val NODETONODEENCRYPTIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NodeToNodeEncryptionOptions"))
    val OFFPEAKWINDOWOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OffPeakWindowOptions"))
    val SNAPSHOTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapshotOptions"))
    val SOFTWAREUPDATEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SoftwareUpdateOptions"))
    val VPCOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VPCOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AIMLOPTIONS_DESCRIPTOR)
        field(ACCESSPOLICIES_DESCRIPTOR)
        field(ADVANCEDOPTIONS_DESCRIPTOR)
        field(ADVANCEDSECURITYOPTIONS_DESCRIPTOR)
        field(AUTOTUNEOPTIONS_DESCRIPTOR)
        field(CLUSTERCONFIG_DESCRIPTOR)
        field(COGNITOOPTIONS_DESCRIPTOR)
        field(DOMAINENDPOINTOPTIONS_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(DRYRUNMODE_DESCRIPTOR)
        field(EBSOPTIONS_DESCRIPTOR)
        field(ENCRYPTIONATRESTOPTIONS_DESCRIPTOR)
        field(IPADDRESSTYPE_DESCRIPTOR)
        field(IDENTITYCENTEROPTIONS_DESCRIPTOR)
        field(LOGPUBLISHINGOPTIONS_DESCRIPTOR)
        field(NODETONODEENCRYPTIONOPTIONS_DESCRIPTOR)
        field(OFFPEAKWINDOWOPTIONS_DESCRIPTOR)
        field(SNAPSHOTOPTIONS_DESCRIPTOR)
        field(SOFTWAREUPDATEOPTIONS_DESCRIPTOR)
        field(VPCOPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aimlOptions?.let { field(AIMLOPTIONS_DESCRIPTOR, it, ::serializeAimlOptionsInputDocument) }
        input.accessPolicies?.let { field(ACCESSPOLICIES_DESCRIPTOR, it) }
        if (input.advancedOptions != null) {
            mapField(ADVANCEDOPTIONS_DESCRIPTOR) {
                input.advancedOptions.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.advancedSecurityOptions?.let { field(ADVANCEDSECURITYOPTIONS_DESCRIPTOR, it, ::serializeAdvancedSecurityOptionsInputDocument) }
        input.autoTuneOptions?.let { field(AUTOTUNEOPTIONS_DESCRIPTOR, it, ::serializeAutoTuneOptionsDocument) }
        input.clusterConfig?.let { field(CLUSTERCONFIG_DESCRIPTOR, it, ::serializeClusterConfigDocument) }
        input.cognitoOptions?.let { field(COGNITOOPTIONS_DESCRIPTOR, it, ::serializeCognitoOptionsDocument) }
        input.domainEndpointOptions?.let { field(DOMAINENDPOINTOPTIONS_DESCRIPTOR, it, ::serializeDomainEndpointOptionsDocument) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.dryRunMode?.let { field(DRYRUNMODE_DESCRIPTOR, it.value) }
        input.ebsOptions?.let { field(EBSOPTIONS_DESCRIPTOR, it, ::serializeEbsOptionsDocument) }
        input.encryptionAtRestOptions?.let { field(ENCRYPTIONATRESTOPTIONS_DESCRIPTOR, it, ::serializeEncryptionAtRestOptionsDocument) }
        input.ipAddressType?.let { field(IPADDRESSTYPE_DESCRIPTOR, it.value) }
        input.identityCenterOptions?.let { field(IDENTITYCENTEROPTIONS_DESCRIPTOR, it, ::serializeIdentityCenterOptionsInputDocument) }
        if (input.logPublishingOptions != null) {
            mapField(LOGPUBLISHINGOPTIONS_DESCRIPTOR) {
                input.logPublishingOptions.forEach { (key, value) -> entry(key.value, asSdkSerializable(value, ::serializeLogPublishingOptionDocument)) }
            }
        }
        input.nodeToNodeEncryptionOptions?.let { field(NODETONODEENCRYPTIONOPTIONS_DESCRIPTOR, it, ::serializeNodeToNodeEncryptionOptionsDocument) }
        input.offPeakWindowOptions?.let { field(OFFPEAKWINDOWOPTIONS_DESCRIPTOR, it, ::serializeOffPeakWindowOptionsDocument) }
        input.snapshotOptions?.let { field(SNAPSHOTOPTIONS_DESCRIPTOR, it, ::serializeSnapshotOptionsDocument) }
        input.softwareUpdateOptions?.let { field(SOFTWAREUPDATEOPTIONS_DESCRIPTOR, it, ::serializeSoftwareUpdateOptionsDocument) }
        input.vpcOptions?.let { field(VPCOPTIONS_DESCRIPTOR, it, ::serializeVpcOptionsDocument) }
    }
    return serializer.toByteArray()
}
