// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.PackageVersionHistory
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetPackageVersionHistoryOperationDeserializer: HttpDeserializer.NonStreaming<GetPackageVersionHistoryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPackageVersionHistoryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPackageVersionHistoryError(context, call, payload)
        }
        val builder = GetPackageVersionHistoryResponse.Builder()

        if (payload != null) {
            deserializeGetPackageVersionHistoryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPackageVersionHistoryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPackageVersionHistoryOperationBody(builder: GetPackageVersionHistoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PACKAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PackageID"))
    val PACKAGEVERSIONHISTORYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PackageVersionHistoryList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PACKAGEID_DESCRIPTOR)
        field(PACKAGEVERSIONHISTORYLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PACKAGEID_DESCRIPTOR.index -> builder.packageId = deserializeString()
                PACKAGEVERSIONHISTORYLIST_DESCRIPTOR.index -> builder.packageVersionHistoryList =
                    deserializer.deserializeList(PACKAGEVERSIONHISTORYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<PackageVersionHistory>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePackageVersionHistoryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
