// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.PackageConfiguration
import aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions
import aws.sdk.kotlin.services.opensearch.model.PackageSource
import aws.sdk.kotlin.services.opensearch.model.PackageType
import aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePackageOperationSerializer: HttpSerializer.NonStreaming<CreatePackageRequest> {
    override fun serialize(context: ExecutionContext, input: CreatePackageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/2021-01-01/packages"
        }

        val payload = serializeCreatePackageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreatePackageOperationBody(context: ExecutionContext, input: CreatePackageRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngineVersion"))
    val PACKAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageConfiguration"))
    val PACKAGEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PackageDescription"))
    val PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageEncryptionOptions"))
    val PACKAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PackageName"))
    val PACKAGESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageSource"))
    val PACKAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PackageType"))
    val PACKAGEVENDINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageVendingOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENGINEVERSION_DESCRIPTOR)
        field(PACKAGECONFIGURATION_DESCRIPTOR)
        field(PACKAGEDESCRIPTION_DESCRIPTOR)
        field(PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR)
        field(PACKAGENAME_DESCRIPTOR)
        field(PACKAGESOURCE_DESCRIPTOR)
        field(PACKAGETYPE_DESCRIPTOR)
        field(PACKAGEVENDINGOPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.packageConfiguration?.let { field(PACKAGECONFIGURATION_DESCRIPTOR, it, ::serializePackageConfigurationDocument) }
        input.packageDescription?.let { field(PACKAGEDESCRIPTION_DESCRIPTOR, it) }
        input.packageEncryptionOptions?.let { field(PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR, it, ::serializePackageEncryptionOptionsDocument) }
        input.packageName?.let { field(PACKAGENAME_DESCRIPTOR, it) }
        input.packageSource?.let { field(PACKAGESOURCE_DESCRIPTOR, it, ::serializePackageSourceDocument) }
        input.packageType?.let { field(PACKAGETYPE_DESCRIPTOR, it.value) }
        input.packageVendingOptions?.let { field(PACKAGEVENDINGOPTIONS_DESCRIPTOR, it, ::serializePackageVendingOptionsDocument) }
    }
    return serializer.toByteArray()
}
