// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.ConnectionMode
import aws.sdk.kotlin.services.opensearch.model.ConnectionProperties
import aws.sdk.kotlin.services.opensearch.model.CreateOutboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.DomainInformationContainer
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOutboundConnectionOperationDeserializer: HttpDeserializer.NonStreaming<CreateOutboundConnectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateOutboundConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateOutboundConnectionError(context, call, payload)
        }
        val builder = CreateOutboundConnectionResponse.Builder()

        if (payload != null) {
            deserializeCreateOutboundConnectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateOutboundConnectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOutboundConnectionOperationBody(builder: CreateOutboundConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionAlias"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionId"))
    val CONNECTIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConnectionMode"))
    val CONNECTIONPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionProperties"))
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val LOCALDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LocalDomainInfo"))
    val REMOTEDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RemoteDomainInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONALIAS_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONMODE_DESCRIPTOR)
        field(CONNECTIONPROPERTIES_DESCRIPTOR)
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(LOCALDOMAININFO_DESCRIPTOR)
        field(REMOTEDOMAININFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONALIAS_DESCRIPTOR.index -> builder.connectionAlias = deserializeString()
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CONNECTIONMODE_DESCRIPTOR.index -> builder.connectionMode = deserializeString().let { ConnectionMode.fromValue(it) }
                CONNECTIONPROPERTIES_DESCRIPTOR.index -> builder.connectionProperties = deserializeConnectionPropertiesDocument(deserializer)
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeOutboundConnectionStatusDocument(deserializer)
                LOCALDOMAININFO_DESCRIPTOR.index -> builder.localDomainInfo = deserializeDomainInformationContainerDocument(deserializer)
                REMOTEDOMAININFO_DESCRIPTOR.index -> builder.remoteDomainInfo = deserializeDomainInformationContainerDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
