// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AppConfig
import aws.sdk.kotlin.services.opensearch.model.CreateApplicationRequest
import aws.sdk.kotlin.services.opensearch.model.DataSource
import aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptionsInput
import aws.sdk.kotlin.services.opensearch.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationOperationSerializer: HttpSerializer.NonStreaming<CreateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: CreateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/2021-01-01/opensearch/application"
        }

        val payload = serializeCreateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApplicationOperationBody(context: ExecutionContext, input: CreateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("appConfigs"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val IAMIDENTITYCENTEROPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iamIdentityCenterOptions"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tagList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPCONFIGS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(IAMIDENTITYCENTEROPTIONS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGLIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.appConfigs != null) {
            listField(APPCONFIGS_DESCRIPTOR) {
                for (el0 in input.appConfigs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAppConfigDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.dataSources != null) {
            listField(DATASOURCES_DESCRIPTOR) {
                for (el0 in input.dataSources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDataSourceDocument))
                }
            }
        }
        input.iamIdentityCenterOptions?.let { field(IAMIDENTITYCENTEROPTIONS_DESCRIPTOR, it, ::serializeIamIdentityCenterOptionsInputDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.tagList != null) {
            listField(TAGLIST_DESCRIPTOR) {
                for (el0 in input.tagList) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
