// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AppConfig
import aws.sdk.kotlin.services.opensearch.model.CreateApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.DataSource
import aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateApplicationOperationDeserializer: HttpDeserializer.NonStreaming<CreateApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateApplicationError(context, call, payload)
        }
        val builder = CreateApplicationResponse.Builder()

        if (payload != null) {
            deserializeCreateApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateApplicationOperationBody(builder: CreateApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("appConfigs"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val IAMIDENTITYCENTEROPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iamIdentityCenterOptions"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tagList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPCONFIGS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(IAMIDENTITYCENTEROPTIONS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPCONFIGS_DESCRIPTOR.index -> builder.appConfigs =
                    deserializer.deserializeList(APPCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AppConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAppConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASOURCES_DESCRIPTOR.index -> builder.dataSources =
                    deserializer.deserializeList(DATASOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<DataSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IAMIDENTITYCENTEROPTIONS_DESCRIPTOR.index -> builder.iamIdentityCenterOptions = deserializeIamIdentityCenterOptionsDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                TAGLIST_DESCRIPTOR.index -> builder.tagList =
                    deserializer.deserializeList(TAGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
