// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AssociatePackageOperationSerializer: HttpSerializer.NonStreaming<AssociatePackageRequest> {
    override fun serialize(context: ExecutionContext, input: AssociatePackageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.packageId) { "packageId is bound to the URI and must not be null" }
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-01-01"))
                add(PercentEncoding.Path.encode("packages"))
                add(PercentEncoding.Path.encode("associate"))
                add(PercentEncoding.SmithyLabel.encode(input.packageId))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
            }
        }

        val payload = serializeAssociatePackageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAssociatePackageOperationBody(context: ExecutionContext, input: AssociatePackageRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSOCIATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AssociationConfiguration"))
    val PREREQUISITEPACKAGEIDLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PrerequisitePackageIDList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATIONCONFIGURATION_DESCRIPTOR)
        field(PREREQUISITEPACKAGEIDLIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.associationConfiguration?.let { field(ASSOCIATIONCONFIGURATION_DESCRIPTOR, it, ::serializePackageAssociationConfigurationDocument) }
        if (input.prerequisitePackageIdList != null) {
            listField(PREREQUISITEPACKAGEIDLIST_DESCRIPTOR) {
                for (el0 in input.prerequisitePackageIdList) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
