// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.paginators

import aws.sdk.kotlin.services.opensearch.OpenSearchClient
import aws.sdk.kotlin.services.opensearch.model.ApplicationSummary
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesResponse
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.ListApplicationsRequest
import aws.sdk.kotlin.services.opensearch.model.ListApplicationsResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainMaintenancesRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainMaintenancesResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageResponse
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsRequest
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsResponse
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainResponse
import aws.sdk.kotlin.services.opensearch.model.ListScheduledActionsRequest
import aws.sdk.kotlin.services.opensearch.model.ListScheduledActionsResponse
import aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest
import aws.sdk.kotlin.services.opensearch.model.ListVersionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDomainAutoTunesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
public fun OpenSearchClient.describeDomainAutoTunesPaginated(initialRequest: DescribeDomainAutoTunesRequest): Flow<DescribeDomainAutoTunesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDomainAutoTunesPaginated.describeDomainAutoTunes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
public fun OpenSearchClient.describeDomainAutoTunesPaginated(block: DescribeDomainAutoTunesRequest.Builder.() -> Unit): Flow<DescribeDomainAutoTunesResponse> =
    describeDomainAutoTunesPaginated(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeInboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInboundConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundConnectionsResponse]
 */
public fun OpenSearchClient.describeInboundConnectionsPaginated(initialRequest: DescribeInboundConnectionsRequest = DescribeInboundConnectionsRequest { }): Flow<DescribeInboundConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInboundConnectionsPaginated.describeInboundConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundConnectionsResponse]
 */
public fun OpenSearchClient.describeInboundConnectionsPaginated(block: DescribeInboundConnectionsRequest.Builder.() -> Unit): Flow<DescribeInboundConnectionsResponse> =
    describeInboundConnectionsPaginated(DescribeInboundConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeOutboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOutboundConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundConnectionsResponse]
 */
public fun OpenSearchClient.describeOutboundConnectionsPaginated(initialRequest: DescribeOutboundConnectionsRequest = DescribeOutboundConnectionsRequest { }): Flow<DescribeOutboundConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOutboundConnectionsPaginated.describeOutboundConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOutboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundConnectionsResponse]
 */
public fun OpenSearchClient.describeOutboundConnectionsPaginated(block: DescribeOutboundConnectionsRequest.Builder.() -> Unit): Flow<DescribeOutboundConnectionsResponse> =
    describeOutboundConnectionsPaginated(DescribeOutboundConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
public fun OpenSearchClient.describePackagesPaginated(initialRequest: DescribePackagesRequest = DescribePackagesRequest { }): Flow<DescribePackagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePackagesPaginated.describePackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
public fun OpenSearchClient.describePackagesPaginated(block: DescribePackagesRequest.Builder.() -> Unit): Flow<DescribePackagesResponse> =
    describePackagesPaginated(DescribePackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedInstanceOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstanceOfferingsResponse]
 */
public fun OpenSearchClient.describeReservedInstanceOfferingsPaginated(initialRequest: DescribeReservedInstanceOfferingsRequest = DescribeReservedInstanceOfferingsRequest { }): Flow<DescribeReservedInstanceOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedInstanceOfferingsPaginated.describeReservedInstanceOfferings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstanceOfferingsResponse]
 */
public fun OpenSearchClient.describeReservedInstanceOfferingsPaginated(block: DescribeReservedInstanceOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedInstanceOfferingsResponse> =
    describeReservedInstanceOfferingsPaginated(DescribeReservedInstanceOfferingsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstancesResponse]
 */
public fun OpenSearchClient.describeReservedInstancesPaginated(initialRequest: DescribeReservedInstancesRequest = DescribeReservedInstancesRequest { }): Flow<DescribeReservedInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedInstancesPaginated.describeReservedInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstancesResponse]
 */
public fun OpenSearchClient.describeReservedInstancesPaginated(block: DescribeReservedInstancesRequest.Builder.() -> Unit): Flow<DescribeReservedInstancesResponse> =
    describeReservedInstancesPaginated(DescribeReservedInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPackageVersionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
public fun OpenSearchClient.getPackageVersionHistoryPaginated(initialRequest: GetPackageVersionHistoryRequest): Flow<GetPackageVersionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPackageVersionHistoryPaginated.getPackageVersionHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
public fun OpenSearchClient.getPackageVersionHistoryPaginated(block: GetPackageVersionHistoryRequest.Builder.() -> Unit): Flow<GetPackageVersionHistoryResponse> =
    getPackageVersionHistoryPaginated(GetPackageVersionHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUpgradeHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
public fun OpenSearchClient.getUpgradeHistoryPaginated(initialRequest: GetUpgradeHistoryRequest): Flow<GetUpgradeHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getUpgradeHistoryPaginated.getUpgradeHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
public fun OpenSearchClient.getUpgradeHistoryPaginated(block: GetUpgradeHistoryRequest.Builder.() -> Unit): Flow<GetUpgradeHistoryResponse> =
    getUpgradeHistoryPaginated(GetUpgradeHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun OpenSearchClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun OpenSearchClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applicationSummaries(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applicationSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainMaintenancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainMaintenancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainMaintenancesResponse]
 */
public fun OpenSearchClient.listDomainMaintenancesPaginated(initialRequest: ListDomainMaintenancesRequest): Flow<ListDomainMaintenancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainMaintenancesPaginated.listDomainMaintenances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainMaintenancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainMaintenancesResponse]
 */
public fun OpenSearchClient.listDomainMaintenancesPaginated(block: ListDomainMaintenancesRequest.Builder.() -> Unit): Flow<ListDomainMaintenancesResponse> =
    listDomainMaintenancesPaginated(ListDomainMaintenancesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsForPackageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
public fun OpenSearchClient.listDomainsForPackagePaginated(initialRequest: ListDomainsForPackageRequest): Flow<ListDomainsForPackageResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsForPackagePaginated.listDomainsForPackage(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
public fun OpenSearchClient.listDomainsForPackagePaginated(block: ListDomainsForPackageRequest.Builder.() -> Unit): Flow<ListDomainsForPackageResponse> =
    listDomainsForPackagePaginated(ListDomainsForPackageRequest.Builder().apply(block).build())

/**
 * Paginate over [ListInstanceTypeDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceTypeDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceTypeDetailsResponse]
 */
public fun OpenSearchClient.listInstanceTypeDetailsPaginated(initialRequest: ListInstanceTypeDetailsRequest): Flow<ListInstanceTypeDetailsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstanceTypeDetailsPaginated.listInstanceTypeDetails(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceTypeDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceTypeDetailsResponse]
 */
public fun OpenSearchClient.listInstanceTypeDetailsPaginated(block: ListInstanceTypeDetailsRequest.Builder.() -> Unit): Flow<ListInstanceTypeDetailsResponse> =
    listInstanceTypeDetailsPaginated(ListInstanceTypeDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagesForDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
public fun OpenSearchClient.listPackagesForDomainPaginated(initialRequest: ListPackagesForDomainRequest): Flow<ListPackagesForDomainResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagesForDomainPaginated.listPackagesForDomain(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
public fun OpenSearchClient.listPackagesForDomainPaginated(block: ListPackagesForDomainRequest.Builder.() -> Unit): Flow<ListPackagesForDomainResponse> =
    listPackagesForDomainPaginated(ListPackagesForDomainRequest.Builder().apply(block).build())

/**
 * Paginate over [ListScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScheduledActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduledActionsResponse]
 */
public fun OpenSearchClient.listScheduledActionsPaginated(initialRequest: ListScheduledActionsRequest): Flow<ListScheduledActionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScheduledActionsPaginated.listScheduledActions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduledActionsResponse]
 */
public fun OpenSearchClient.listScheduledActionsPaginated(block: ListScheduledActionsRequest.Builder.() -> Unit): Flow<ListScheduledActionsResponse> =
    listScheduledActionsPaginated(ListScheduledActionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun OpenSearchClient.listVersionsPaginated(initialRequest: ListVersionsRequest = ListVersionsRequest { }): Flow<ListVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVersionsPaginated.listVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun OpenSearchClient.listVersionsPaginated(block: ListVersionsRequest.Builder.() -> Unit): Flow<ListVersionsResponse> =
    listVersionsPaginated(ListVersionsRequest.Builder().apply(block).build())
