// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint. For more information, see [Launching your Amazon OpenSearch Service domains using a VPC](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
 */
public class VpcOptions private constructor(builder: Builder) {
    /**
     * The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.VpcOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcOptions(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (this.subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcOptions

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.VpcOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.VpcOptions) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.VpcOptions = VpcOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
