// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Information about the subnets and security groups for an Amazon OpenSearch Service domain provisioned within a virtual private cloud (VPC). For more information, see [Launching your Amazon OpenSearch Service domains using a VPC](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html). This information only exists if the domain was created with `VPCOptions`.
 */
public class VpcDerivedInfo private constructor(builder: Builder) {
    /**
     * The list of Availability Zones associated with the VPC subnets.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The list of security group IDs associated with the VPC endpoints for the domain.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs associated with the VPC endpoints for the domain.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The ID for your VPC. Amazon VPC generates this value when you create a VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcDerivedInfo(")
        append("availabilityZones=$availabilityZones,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (this.securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (this.subnetIds?.hashCode() ?: 0)
        result = 31 * result + (this.vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcDerivedInfo

        if (availabilityZones != other.availabilityZones) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of Availability Zones associated with the VPC subnets.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The list of security group IDs associated with the VPC endpoints for the domain.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs associated with the VPC endpoints for the domain.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID for your VPC. Amazon VPC generates this value when you create a VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo) : this() {
            this.availabilityZones = x.availabilityZones
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo = VpcDerivedInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
