// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


public class UpdateScheduledActionRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the action to reschedule. To retrieve this ID, send a [ListScheduledActions](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html) request.
     */
    public val actionId: kotlin.String? = builder.actionId
    /**
     * The type of action to reschedule. Can be one of `SERVICE_SOFTWARE_UPDATE`, `JVM_HEAP_SIZE_TUNING`, or `JVM_YOUNG_GEN_TUNING`. To retrieve this value, send a [ListScheduledActions](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html) request.
     */
    public val actionType: aws.sdk.kotlin.services.opensearch.model.ActionType? = builder.actionType
    /**
     * The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you set `ScheduleAt` to `TIMESTAMP`.
     */
    public val desiredStartTime: kotlin.Long? = builder.desiredStartTime
    /**
     * The name of the domain to reschedule an action for.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * When to schedule the action.
     * + `NOW` - Immediately schedules the update to happen in the current hour if there's capacity available.
     * + `TIMESTAMP` - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for `DesiredStartTime`.
     * + `OFF_PEAK_WINDOW` - Marks the action to be picked up during an upcoming off-peak window. There's no guarantee that the change will be implemented during the next immediate window. Depending on capacity, it might happen in subsequent days.
     */
    public val scheduleAt: aws.sdk.kotlin.services.opensearch.model.ScheduleAt? = builder.scheduleAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateScheduledActionRequest(")
        append("actionId=$actionId,")
        append("actionType=$actionType,")
        append("desiredStartTime=$desiredStartTime,")
        append("domainName=$domainName,")
        append("scheduleAt=$scheduleAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId?.hashCode() ?: 0
        result = 31 * result + (this.actionType?.hashCode() ?: 0)
        result = 31 * result + (this.desiredStartTime?.hashCode() ?: 0)
        result = 31 * result + (this.domainName?.hashCode() ?: 0)
        result = 31 * result + (this.scheduleAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateScheduledActionRequest

        if (actionId != other.actionId) return false
        if (actionType != other.actionType) return false
        if (desiredStartTime != other.desiredStartTime) return false
        if (domainName != other.domainName) return false
        if (scheduleAt != other.scheduleAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the action to reschedule. To retrieve this ID, send a [ListScheduledActions](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html) request.
         */
        public var actionId: kotlin.String? = null
        /**
         * The type of action to reschedule. Can be one of `SERVICE_SOFTWARE_UPDATE`, `JVM_HEAP_SIZE_TUNING`, or `JVM_YOUNG_GEN_TUNING`. To retrieve this value, send a [ListScheduledActions](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html) request.
         */
        public var actionType: aws.sdk.kotlin.services.opensearch.model.ActionType? = null
        /**
         * The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you set `ScheduleAt` to `TIMESTAMP`.
         */
        public var desiredStartTime: kotlin.Long? = null
        /**
         * The name of the domain to reschedule an action for.
         */
        public var domainName: kotlin.String? = null
        /**
         * When to schedule the action.
         * + `NOW` - Immediately schedules the update to happen in the current hour if there's capacity available.
         * + `TIMESTAMP` - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for `DesiredStartTime`.
         * + `OFF_PEAK_WINDOW` - Marks the action to be picked up during an upcoming off-peak window. There's no guarantee that the change will be implemented during the next immediate window. Depending on capacity, it might happen in subsequent days.
         */
        public var scheduleAt: aws.sdk.kotlin.services.opensearch.model.ScheduleAt? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest) : this() {
            this.actionId = x.actionId
            this.actionType = x.actionType
            this.desiredStartTime = x.desiredStartTime
            this.domainName = x.domainName
            this.scheduleAt = x.scheduleAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest = UpdateScheduledActionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
