// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Limits that are applicable for the given Amazon OpenSearch Service storage type.
 */
public class StorageTypeLimit private constructor(builder: Builder) {
    /**
     * Name of storage limits that are applicable for the given storage type. If `StorageType` is `ebs`, the following options are available:
     * + **MinimumVolumeSize** - Minimum volume size that is available for the given storage type. Can be empty if not applicable.
     * + **MaximumVolumeSize** - Maximum volume size that is available for the given storage type. Can be empty if not applicable.
     * + **MaximumIops** - Maximum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.
     * + **MinimumIops** - Minimum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.
     * + **MaximumThroughput** - Maximum amount of throughput that is available for the given the storage type. Can be empty if not applicable.
     * + **MinimumThroughput** - Minimum amount of throughput that is available for the given the storage type. Can be empty if not applicable.
     */
    public val limitName: kotlin.String? = builder.limitName
    /**
     * The limit values.
     */
    public val limitValues: List<String>? = builder.limitValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.StorageTypeLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageTypeLimit(")
        append("limitName=$limitName,")
        append("limitValues=$limitValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = limitName?.hashCode() ?: 0
        result = 31 * result + (this.limitValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageTypeLimit

        if (limitName != other.limitName) return false
        if (limitValues != other.limitValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.StorageTypeLimit = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of storage limits that are applicable for the given storage type. If `StorageType` is `ebs`, the following options are available:
         * + **MinimumVolumeSize** - Minimum volume size that is available for the given storage type. Can be empty if not applicable.
         * + **MaximumVolumeSize** - Maximum volume size that is available for the given storage type. Can be empty if not applicable.
         * + **MaximumIops** - Maximum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.
         * + **MinimumIops** - Minimum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.
         * + **MaximumThroughput** - Maximum amount of throughput that is available for the given the storage type. Can be empty if not applicable.
         * + **MinimumThroughput** - Minimum amount of throughput that is available for the given the storage type. Can be empty if not applicable.
         */
        public var limitName: kotlin.String? = null
        /**
         * The limit values.
         */
        public var limitValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.StorageTypeLimit) : this() {
            this.limitName = x.limitName
            this.limitValues = x.limitValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.StorageTypeLimit = StorageTypeLimit(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
