// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


/**
 * Specifies details about a scheduled Auto-Tune action. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
 */
public class ScheduledAutoTuneDetails private constructor(builder: Builder) {
    /**
     * A description of the Auto-Tune action.
     */
    public val action: kotlin.String? = builder.action
    /**
     * The type of Auto-Tune action.
     */
    public val actionType: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneActionType? = builder.actionType
    /**
     * The date and time when the Auto-Tune action is scheduled for the domain.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The severity of the Auto-Tune action. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
     */
    public val severity: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneSeverityType? = builder.severity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAutoTuneDetails(")
        append("action=$action,")
        append("actionType=$actionType,")
        append("date=$date,")
        append("severity=$severity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (this.actionType?.hashCode() ?: 0)
        result = 31 * result + (this.date?.hashCode() ?: 0)
        result = 31 * result + (this.severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAutoTuneDetails

        if (action != other.action) return false
        if (actionType != other.actionType) return false
        if (date != other.date) return false
        if (severity != other.severity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the Auto-Tune action.
         */
        public var action: kotlin.String? = null
        /**
         * The type of Auto-Tune action.
         */
        public var actionType: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneActionType? = null
        /**
         * The date and time when the Auto-Tune action is scheduled for the domain.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The severity of the Auto-Tune action. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
         */
        public var severity: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneSeverityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails) : this() {
            this.action = x.action
            this.actionType = x.actionType
            this.date = x.date
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = ScheduledAutoTuneDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
