// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Information about a scheduled configuration change for an OpenSearch Service domain. This actions can be a [service software update](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or a [blue/green Auto-Tune enhancement](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
 */
public class ScheduledAction private constructor(builder: Builder) {
    /**
     * Whether or not the scheduled action is cancellable.
     */
    public val cancellable: kotlin.Boolean? = builder.cancellable
    /**
     * A description of the action to be taken.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the scheduled action.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Whether the action is required or optional.
     */
    public val mandatory: kotlin.Boolean? = builder.mandatory
    /**
     * Whether the action was scheduled manually (`CUSTOMER`, or by OpenSearch Service automatically (`SYSTEM`).
     */
    public val scheduledBy: aws.sdk.kotlin.services.opensearch.model.ScheduledBy? = builder.scheduledBy
    /**
     * The time when the change is scheduled to happen.
     */
    public val scheduledTime: kotlin.Long = requireNotNull(builder.scheduledTime) { "A non-null value must be provided for scheduledTime" }
    /**
     * The severity of the action.
     */
    public val severity: aws.sdk.kotlin.services.opensearch.model.ActionSeverity = requireNotNull(builder.severity) { "A non-null value must be provided for severity" }
    /**
     * The current status of the scheduled action.
     */
    public val status: aws.sdk.kotlin.services.opensearch.model.ActionStatus? = builder.status
    /**
     * The type of action that will be taken on the domain.
     */
    public val type: aws.sdk.kotlin.services.opensearch.model.ActionType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ScheduledAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAction(")
        append("cancellable=$cancellable,")
        append("description=$description,")
        append("id=$id,")
        append("mandatory=$mandatory,")
        append("scheduledBy=$scheduledBy,")
        append("scheduledTime=$scheduledTime,")
        append("severity=$severity,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cancellable?.hashCode() ?: 0
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.id.hashCode())
        result = 31 * result + (this.mandatory?.hashCode() ?: 0)
        result = 31 * result + (this.scheduledBy?.hashCode() ?: 0)
        result = 31 * result + (this.scheduledTime.hashCode())
        result = 31 * result + (this.severity.hashCode())
        result = 31 * result + (this.status?.hashCode() ?: 0)
        result = 31 * result + (this.type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAction

        if (cancellable != other.cancellable) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (mandatory != other.mandatory) return false
        if (scheduledBy != other.scheduledBy) return false
        if (scheduledTime != other.scheduledTime) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ScheduledAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether or not the scheduled action is cancellable.
         */
        public var cancellable: kotlin.Boolean? = null
        /**
         * A description of the action to be taken.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the scheduled action.
         */
        public var id: kotlin.String? = null
        /**
         * Whether the action is required or optional.
         */
        public var mandatory: kotlin.Boolean? = null
        /**
         * Whether the action was scheduled manually (`CUSTOMER`, or by OpenSearch Service automatically (`SYSTEM`).
         */
        public var scheduledBy: aws.sdk.kotlin.services.opensearch.model.ScheduledBy? = null
        /**
         * The time when the change is scheduled to happen.
         */
        public var scheduledTime: kotlin.Long? = null
        /**
         * The severity of the action.
         */
        public var severity: aws.sdk.kotlin.services.opensearch.model.ActionSeverity? = null
        /**
         * The current status of the scheduled action.
         */
        public var status: aws.sdk.kotlin.services.opensearch.model.ActionStatus? = null
        /**
         * The type of action that will be taken on the domain.
         */
        public var type: aws.sdk.kotlin.services.opensearch.model.ActionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ScheduledAction) : this() {
            this.cancellable = x.cancellable
            this.description = x.description
            this.id = x.id
            this.mandatory = x.mandatory
            this.scheduledBy = x.scheduledBy
            this.scheduledTime = x.scheduledTime
            this.severity = x.severity
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ScheduledAction = ScheduledAction(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (scheduledTime == null) scheduledTime = 0L
            if (severity == null) severity = ActionSeverity.SdkUnknown("no value provided")
            if (type == null) type = ActionType.SdkUnknown("no value provided")
            return this
        }
    }
}
