// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesOpensearchModelSamlIdpDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.SamlIdp

/**
 * The SAML authentication configuration for an Amazon OpenSearch Service domain.
 */
public class SamlOptionsInput private constructor(builder: Builder) {
    /**
     * True to enable SAML authentication for a domain.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The SAML Identity Provider's information.
     */
    public val idp: aws.sdk.kotlin.services.opensearch.model.SamlIdp? = builder.idp
    /**
     * The backend role that the SAML master user is mapped to.
     */
    public val masterBackendRole: kotlin.String? = builder.masterBackendRole
    /**
     * The SAML master user name, which is stored in the domain's internal user database.
     */
    public val masterUserName: kotlin.String? = builder.masterUserName
    /**
     * Element of the SAML assertion to use for backend roles. Default is `roles`.
     */
    public val rolesKey: kotlin.String? = builder.rolesKey
    /**
     * The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
     */
    public val sessionTimeoutMinutes: kotlin.Int? = builder.sessionTimeoutMinutes
    /**
     * Element of the SAML assertion to use for the user name. Default is `NameID`.
     */
    public val subjectKey: kotlin.String? = builder.subjectKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlOptionsInput(")
        append("enabled=$enabled,")
        append("idp=$idp,")
        append("masterBackendRole=$masterBackendRole,")
        append("masterUserName=*** Sensitive Data Redacted ***,")
        append("rolesKey=$rolesKey,")
        append("sessionTimeoutMinutes=$sessionTimeoutMinutes,")
        append("subjectKey=$subjectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (this.idp?.hashCode() ?: 0)
        result = 31 * result + (this.masterBackendRole?.hashCode() ?: 0)
        result = 31 * result + (this.masterUserName?.hashCode() ?: 0)
        result = 31 * result + (this.rolesKey?.hashCode() ?: 0)
        result = 31 * result + (this.sessionTimeoutMinutes ?: 0)
        result = 31 * result + (this.subjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlOptionsInput

        if (enabled != other.enabled) return false
        if (idp != other.idp) return false
        if (masterBackendRole != other.masterBackendRole) return false
        if (masterUserName != other.masterUserName) return false
        if (rolesKey != other.rolesKey) return false
        if (sessionTimeoutMinutes != other.sessionTimeoutMinutes) return false
        if (subjectKey != other.subjectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * True to enable SAML authentication for a domain.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The SAML Identity Provider's information.
         */
        public var idp: aws.sdk.kotlin.services.opensearch.model.SamlIdp? = null
        /**
         * The backend role that the SAML master user is mapped to.
         */
        public var masterBackendRole: kotlin.String? = null
        /**
         * The SAML master user name, which is stored in the domain's internal user database.
         */
        public var masterUserName: kotlin.String? = null
        /**
         * Element of the SAML assertion to use for backend roles. Default is `roles`.
         */
        public var rolesKey: kotlin.String? = null
        /**
         * The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
         */
        public var sessionTimeoutMinutes: kotlin.Int? = null
        /**
         * Element of the SAML assertion to use for the user name. Default is `NameID`.
         */
        public var subjectKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput) : this() {
            this.enabled = x.enabled
            this.idp = x.idp
            this.masterBackendRole = x.masterBackendRole
            this.masterUserName = x.masterUserName
            this.rolesKey = x.rolesKey
            this.sessionTimeoutMinutes = x.sessionTimeoutMinutes
            this.subjectKey = x.subjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput = SamlOptionsInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SamlIdp] inside the given [block]
         */
        public fun idp(block: aws.sdk.kotlin.services.opensearch.model.SamlIdp.Builder.() -> kotlin.Unit) {
            this.idp = awsSdkKotlinServicesOpensearchModelSamlIdpDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
