// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Details of an OpenSearch Reserved Instance offering.
 */
public class ReservedInstanceOffering private constructor(builder: Builder) {
    /**
     * The currency code for the Reserved Instance offering.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the offering will reserve the OpenSearch instance.
     */
    public val duration: kotlin.Int = builder.duration
    /**
     * The upfront fixed charge you will pay to purchase the specific Reserved Instance offering.
     */
    public val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The OpenSearch instance type offered by the Reserved Instance offering.
     */
    public val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * Payment option for the Reserved Instance offering
     */
    public val paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = builder.paymentOption
    /**
     * The recurring charge to your account, regardless of whether you creates any domains using the offering.
     */
    public val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The unique identifier of the Reserved Instance offering.
     */
    public val reservedInstanceOfferingId: kotlin.String? = builder.reservedInstanceOfferingId
    /**
     * The hourly rate at which you're charged for the domain using this Reserved Instance.
     */
    public val usagePrice: kotlin.Double? = builder.usagePrice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstanceOffering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("instanceType=$instanceType,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservedInstanceOfferingId=$reservedInstanceOfferingId,")
        append("usagePrice=$usagePrice")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (this.duration)
        result = 31 * result + (this.fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (this.instanceType?.hashCode() ?: 0)
        result = 31 * result + (this.paymentOption?.hashCode() ?: 0)
        result = 31 * result + (this.recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (this.reservedInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (this.usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstanceOffering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (!(fixedPrice?.equals(other.fixedPrice) ?: (other.fixedPrice == null))) return false
        if (instanceType != other.instanceType) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedInstanceOfferingId != other.reservedInstanceOfferingId) return false
        if (!(usagePrice?.equals(other.usagePrice) ?: (other.usagePrice == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The currency code for the Reserved Instance offering.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the offering will reserve the OpenSearch instance.
         */
        public var duration: kotlin.Int = 0
        /**
         * The upfront fixed charge you will pay to purchase the specific Reserved Instance offering.
         */
        public var fixedPrice: kotlin.Double? = null
        /**
         * The OpenSearch instance type offered by the Reserved Instance offering.
         */
        public var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * Payment option for the Reserved Instance offering
         */
        public var paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = null
        /**
         * The recurring charge to your account, regardless of whether you creates any domains using the offering.
         */
        public var recurringCharges: List<RecurringCharge>? = null
        /**
         * The unique identifier of the Reserved Instance offering.
         */
        public var reservedInstanceOfferingId: kotlin.String? = null
        /**
         * The hourly rate at which you're charged for the domain using this Reserved Instance.
         */
        public var usagePrice: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.instanceType = x.instanceType
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservedInstanceOfferingId = x.reservedInstanceOfferingId
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = ReservedInstanceOffering(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
