// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesOpensearchModelWindowStartTimeDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.WindowStartTime

/**
 * A custom 10-hour, low-traffic window during which OpenSearch Service can perform mandatory configuration changes on the domain. These actions can include scheduled service software updates and blue/green Auto-Tune enhancements. OpenSearch Service will schedule these actions during the window that you specify.
 *
 * If you don't specify a window start time, it defaults to 10:00 P.M. local time.
 *
 * For more information, see [Defining off-peak maintenance windows for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html).
 */
public class OffPeakWindow private constructor(builder: Builder) {
    /**
     * A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start time, the end time will automatically be set to 9:00 A.M.
     */
    public val windowStartTime: aws.sdk.kotlin.services.opensearch.model.WindowStartTime? = builder.windowStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.OffPeakWindow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OffPeakWindow(")
        append("windowStartTime=$windowStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = windowStartTime?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OffPeakWindow

        if (windowStartTime != other.windowStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.OffPeakWindow = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start time, the end time will automatically be set to 9:00 A.M.
         */
        public var windowStartTime: aws.sdk.kotlin.services.opensearch.model.WindowStartTime? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.OffPeakWindow) : this() {
            this.windowStartTime = x.windowStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.OffPeakWindow = OffPeakWindow(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.WindowStartTime] inside the given [block]
         */
        public fun windowStartTime(block: aws.sdk.kotlin.services.opensearch.model.WindowStartTime.Builder.() -> kotlin.Unit) {
            this.windowStartTime = awsSdkKotlinServicesOpensearchModelWindowStartTimeDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
