// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Information about the domain properties that are currently being modified.
 */
public class ModifyingProperties private constructor(builder: Builder) {
    /**
     * The current value of the domain property that is being modified.
     */
    public val activeValue: kotlin.String? = builder.activeValue
    /**
     * The name of the property that is currently being modified.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The value that the property that is currently being modified will eventually have.
     */
    public val pendingValue: kotlin.String? = builder.pendingValue
    /**
     * The type of value that is currently being modified. Properties can have two types:
     * + `PLAIN_TEXT`: Contain direct values such as "1", "True", or "c5.large.search".
     * + `STRINGIFIED_JSON`: Contain content in JSON format, such as {"Enabled":"True"}".
     */
    public val valueType: aws.sdk.kotlin.services.opensearch.model.PropertyValueType? = builder.valueType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ModifyingProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyingProperties(")
        append("activeValue=$activeValue,")
        append("name=$name,")
        append("pendingValue=$pendingValue,")
        append("valueType=$valueType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeValue?.hashCode() ?: 0
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.pendingValue?.hashCode() ?: 0)
        result = 31 * result + (this.valueType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyingProperties

        if (activeValue != other.activeValue) return false
        if (name != other.name) return false
        if (pendingValue != other.pendingValue) return false
        if (valueType != other.valueType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ModifyingProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current value of the domain property that is being modified.
         */
        public var activeValue: kotlin.String? = null
        /**
         * The name of the property that is currently being modified.
         */
        public var name: kotlin.String? = null
        /**
         * The value that the property that is currently being modified will eventually have.
         */
        public var pendingValue: kotlin.String? = null
        /**
         * The type of value that is currently being modified. Properties can have two types:
         * + `PLAIN_TEXT`: Contain direct values such as "1", "True", or "c5.large.search".
         * + `STRINGIFIED_JSON`: Contain content in JSON format, such as {"Enabled":"True"}".
         */
        public var valueType: aws.sdk.kotlin.services.opensearch.model.PropertyValueType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ModifyingProperties) : this() {
            this.activeValue = x.activeValue
            this.name = x.name
            this.pendingValue = x.pendingValue
            this.valueType = x.valueType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ModifyingProperties = ModifyingProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
