// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Specifies whether the Amazon OpenSearch Service domain publishes the OpenSearch application and slow logs to Amazon CloudWatch. For more information, see [Monitoring OpenSearch logs with Amazon CloudWatch Logs](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html).
 *
 * After you enable log publishing, you still have to enable the collection of slow logs using the OpenSearch REST API.
 */
public class LogPublishingOption private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Logs group to publish logs to.
     */
    public val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * Whether the log should be published.
     */
    public val enabled: kotlin.Boolean? = builder.enabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.LogPublishingOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogPublishingOption(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("enabled=$enabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (this.enabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogPublishingOption

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (enabled != other.enabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.LogPublishingOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs group to publish logs to.
         */
        public var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * Whether the log should be published.
         */
        public var enabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.LogPublishingOption) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.enabled = x.enabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.LogPublishingOption = LogPublishingOption(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
