// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Container for the request parameters to the `ListPackagesForDomain` operation.
 */
public class ListPackagesForDomainRequest private constructor(builder: Builder) {
    /**
     * The name of the domain for which you want to list associated packages.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If your initial `ListPackagesForDomain` operation returns a `nextToken`, you can include the returned `nextToken` in subsequent `ListPackagesForDomain` operations, which returns results in the next page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPackagesForDomainRequest(")
        append("domainName=$domainName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (this.maxResults ?: 0)
        result = 31 * result + (this.nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPackagesForDomainRequest

        if (domainName != other.domainName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the domain for which you want to list associated packages.
         */
        public var domainName: kotlin.String? = null
        /**
         * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If your initial `ListPackagesForDomain` operation returns a `nextToken`, you can include the returned `nextToken` in subsequent `ListPackagesForDomain` operations, which returns results in the next page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest) : this() {
            this.domainName = x.domainName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest = ListPackagesForDomainRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
