// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * The status of an inbound cross-cluster connection for OpenSearch Service.
 */
public class InboundConnectionStatus private constructor(builder: Builder) {
    /**
     * Information about the connection.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status code for the connection. Can be one of the following:
     * + **PENDING_ACCEPTANCE** - Inbound connection is not yet accepted by the remote domain owner.
     * + **APPROVED**: Inbound connection is pending acceptance by the remote domain owner.
     * + **PROVISIONING**: Inbound connection is being provisioned.
     * + **ACTIVE**: Inbound connection is active and ready to use.
     * + **REJECTING**: Inbound connection rejection is in process.
     * + **REJECTED**: Inbound connection is rejected.
     * + **DELETING**: Inbound connection deletion is in progress.
     * + **DELETED**: Inbound connection is deleted and can no longer be used.
     */
    public val statusCode: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatusCode? = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InboundConnectionStatus(")
        append("message=$message,")
        append("statusCode=$statusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (this.statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InboundConnectionStatus

        if (message != other.message) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the connection.
         */
        public var message: kotlin.String? = null
        /**
         * The status code for the connection. Can be one of the following:
         * + **PENDING_ACCEPTANCE** - Inbound connection is not yet accepted by the remote domain owner.
         * + **APPROVED**: Inbound connection is pending acceptance by the remote domain owner.
         * + **PROVISIONING**: Inbound connection is being provisioned.
         * + **ACTIVE**: Inbound connection is active and ready to use.
         * + **REJECTING**: Inbound connection rejection is in process.
         * + **REJECTED**: Inbound connection is rejected.
         * + **DELETING**: Inbound connection deletion is in progress.
         * + **DELETED**: Inbound connection is deleted and can no longer be used.
         */
        public var statusCode: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatusCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus) : this() {
            this.message = x.message
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = InboundConnectionStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
