// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Settings container for integrating IAM Identity Center with OpenSearch UI applications, which enables enabling secure user authentication and access control across multiple data sources. This setup supports single sign-on (SSO) through IAM Identity Center, allowing centralized user management.
 */
public class IdentityCenterOptions private constructor(builder: Builder) {
    /**
     * Indicates whether IAM Identity Center is enabled for the application.
     */
    public val enabledApiAccess: kotlin.Boolean? = builder.enabledApiAccess
    /**
     * The ARN of the IAM Identity Center application that integrates with Amazon OpenSearch Service.
     */
    public val identityCenterApplicationArn: kotlin.String? = builder.identityCenterApplicationArn
    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance.
     */
    public val identityCenterInstanceArn: kotlin.String? = builder.identityCenterInstanceArn
    /**
     * The identifier of the IAM Identity Store.
     */
    public val identityStoreId: kotlin.String? = builder.identityStoreId
    /**
     * Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
     */
    public val rolesKey: aws.sdk.kotlin.services.opensearch.model.RolesKeyIdCOption? = builder.rolesKey
    /**
     * Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
     */
    public val subjectKey: aws.sdk.kotlin.services.opensearch.model.SubjectKeyIdCOption? = builder.subjectKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityCenterOptions(")
        append("enabledApiAccess=$enabledApiAccess,")
        append("identityCenterApplicationArn=$identityCenterApplicationArn,")
        append("identityCenterInstanceArn=$identityCenterInstanceArn,")
        append("identityStoreId=$identityStoreId,")
        append("rolesKey=$rolesKey,")
        append("subjectKey=$subjectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabledApiAccess?.hashCode() ?: 0
        result = 31 * result + (this.identityCenterApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (this.identityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (this.identityStoreId?.hashCode() ?: 0)
        result = 31 * result + (this.rolesKey?.hashCode() ?: 0)
        result = 31 * result + (this.subjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityCenterOptions

        if (enabledApiAccess != other.enabledApiAccess) return false
        if (identityCenterApplicationArn != other.identityCenterApplicationArn) return false
        if (identityCenterInstanceArn != other.identityCenterInstanceArn) return false
        if (identityStoreId != other.identityStoreId) return false
        if (rolesKey != other.rolesKey) return false
        if (subjectKey != other.subjectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether IAM Identity Center is enabled for the application.
         */
        public var enabledApiAccess: kotlin.Boolean? = null
        /**
         * The ARN of the IAM Identity Center application that integrates with Amazon OpenSearch Service.
         */
        public var identityCenterApplicationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance.
         */
        public var identityCenterInstanceArn: kotlin.String? = null
        /**
         * The identifier of the IAM Identity Store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
         */
        public var rolesKey: aws.sdk.kotlin.services.opensearch.model.RolesKeyIdCOption? = null
        /**
         * Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
         */
        public var subjectKey: aws.sdk.kotlin.services.opensearch.model.SubjectKeyIdCOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptions) : this() {
            this.enabledApiAccess = x.enabledApiAccess
            this.identityCenterApplicationArn = x.identityCenterApplicationArn
            this.identityCenterInstanceArn = x.identityCenterInstanceArn
            this.identityStoreId = x.identityStoreId
            this.rolesKey = x.rolesKey
            this.subjectKey = x.subjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptions = IdentityCenterOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
