// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Configuration settings for enabling and managing IAM Identity Center.
 */
public class IamIdentityCenterOptionsInput private constructor(builder: Builder) {
    /**
     * Specifies whether IAM Identity Center is enabled or disabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
     */
    public val iamIdentityCenterInstanceArn: kotlin.String? = builder.iamIdentityCenterInstanceArn
    /**
     * The ARN of the IAM role associated with the IAM Identity Center application.
     */
    public val iamRoleForIdentityCenterApplicationArn: kotlin.String? = builder.iamRoleForIdentityCenterApplicationArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IamIdentityCenterOptionsInput(")
        append("enabled=$enabled,")
        append("iamIdentityCenterInstanceArn=$iamIdentityCenterInstanceArn,")
        append("iamRoleForIdentityCenterApplicationArn=$iamRoleForIdentityCenterApplicationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (this.iamIdentityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (this.iamRoleForIdentityCenterApplicationArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IamIdentityCenterOptionsInput

        if (enabled != other.enabled) return false
        if (iamIdentityCenterInstanceArn != other.iamIdentityCenterInstanceArn) return false
        if (iamRoleForIdentityCenterApplicationArn != other.iamRoleForIdentityCenterApplicationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether IAM Identity Center is enabled or disabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
         */
        public var iamIdentityCenterInstanceArn: kotlin.String? = null
        /**
         * The ARN of the IAM role associated with the IAM Identity Center application.
         */
        public var iamRoleForIdentityCenterApplicationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptionsInput) : this() {
            this.enabled = x.enabled
            this.iamIdentityCenterInstanceArn = x.iamIdentityCenterInstanceArn
            this.iamRoleForIdentityCenterApplicationArn = x.iamRoleForIdentityCenterApplicationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptionsInput = IamIdentityCenterOptionsInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
