// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Configuration settings for IAM Identity Center in an OpenSearch application.
 */
public class IamIdentityCenterOptions private constructor(builder: Builder) {
    /**
     * Indicates whether IAM Identity Center is enabled for the OpenSearch application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
     */
    public val iamIdentityCenterApplicationArn: kotlin.String? = builder.iamIdentityCenterApplicationArn
    /**
     * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
     */
    public val iamIdentityCenterInstanceArn: kotlin.String? = builder.iamIdentityCenterInstanceArn
    /**
     * The Amazon Resource Name (ARN) of the IAM role assigned to the IAM Identity Center application for the OpenSearch application.
     */
    public val iamRoleForIdentityCenterApplicationArn: kotlin.String? = builder.iamRoleForIdentityCenterApplicationArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IamIdentityCenterOptions(")
        append("enabled=$enabled,")
        append("iamIdentityCenterApplicationArn=$iamIdentityCenterApplicationArn,")
        append("iamIdentityCenterInstanceArn=$iamIdentityCenterInstanceArn,")
        append("iamRoleForIdentityCenterApplicationArn=$iamRoleForIdentityCenterApplicationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (this.iamIdentityCenterApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (this.iamIdentityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (this.iamRoleForIdentityCenterApplicationArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IamIdentityCenterOptions

        if (enabled != other.enabled) return false
        if (iamIdentityCenterApplicationArn != other.iamIdentityCenterApplicationArn) return false
        if (iamIdentityCenterInstanceArn != other.iamIdentityCenterInstanceArn) return false
        if (iamRoleForIdentityCenterApplicationArn != other.iamRoleForIdentityCenterApplicationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether IAM Identity Center is enabled for the OpenSearch application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
         */
        public var iamIdentityCenterApplicationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
         */
        public var iamIdentityCenterInstanceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role assigned to the IAM Identity Center application for the OpenSearch application.
         */
        public var iamRoleForIdentityCenterApplicationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions) : this() {
            this.enabled = x.enabled
            this.iamIdentityCenterApplicationArn = x.iamIdentityCenterApplicationArn
            this.iamIdentityCenterInstanceArn = x.iamIdentityCenterInstanceArn
            this.iamRoleForIdentityCenterApplicationArn = x.iamRoleForIdentityCenterApplicationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions = IamIdentityCenterOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
