// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Results of a dry run performed in an update domain request.
 */
public class DryRunResults private constructor(builder: Builder) {
    /**
     * Specifies the way in which OpenSearch Service will apply an update. Possible values are:
     * + **Blue/Green** - The update requires a blue/green deployment.
     * + **DynamicUpdate** - No blue/green deployment required
     * + **Undetermined** - The domain is in the middle of an update and can't predict the deployment type. Try again after the update is complete.
     * + **None** - The request doesn't include any configuration changes.
     */
    public val deploymentType: kotlin.String? = builder.deploymentType
    /**
     * A message corresponding to the deployment type.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DryRunResults = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DryRunResults(")
        append("deploymentType=$deploymentType,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentType?.hashCode() ?: 0
        result = 31 * result + (this.message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DryRunResults

        if (deploymentType != other.deploymentType) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DryRunResults = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the way in which OpenSearch Service will apply an update. Possible values are:
         * + **Blue/Green** - The update requires a blue/green deployment.
         * + **DynamicUpdate** - No blue/green deployment required
         * + **Undetermined** - The domain is in the middle of an update and can't predict the deployment type. Try again after the update is complete.
         * + **None** - The request doesn't include any configuration changes.
         */
        public var deploymentType: kotlin.String? = null
        /**
         * A message corresponding to the deployment type.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DryRunResults) : this() {
            this.deploymentType = x.deploymentType
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DryRunResults = DryRunResults(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
