// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesOpensearchModelPackageAssociationConfigurationDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration
private val awsSdkKotlinServicesOpensearchModelErrorDetailsDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.ErrorDetails

/**
 * Information about a package that is associated with a domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public class DomainPackageDetails private constructor(builder: Builder) {
    /**
     * The configuration for associating a package with an Amazon OpenSearch Service domain.
     */
    public val associationConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration? = builder.associationConfiguration
    /**
     * Name of the domain that the package is associated with.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * State of the association.
     */
    public val domainPackageStatus: aws.sdk.kotlin.services.opensearch.model.DomainPackageStatus? = builder.domainPackageStatus
    /**
     * Additional information if the package is in an error state. Null otherwise.
     */
    public val errorDetails: aws.sdk.kotlin.services.opensearch.model.ErrorDetails? = builder.errorDetails
    /**
     * Timestamp of the most recent update to the package association status.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * Internal ID of the package.
     */
    public val packageId: kotlin.String? = builder.packageId
    /**
     * User-specified name of the package.
     */
    public val packageName: kotlin.String? = builder.packageName
    /**
     * The type of package.
     */
    public val packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = builder.packageType
    /**
     * The current version of the package.
     */
    public val packageVersion: kotlin.String? = builder.packageVersion
    /**
     * A list of package IDs that must be associated with the domain before or with the package can be associated.
     */
    public val prerequisitePackageIdList: List<String>? = builder.prerequisitePackageIdList
    /**
     * The relative path of the package on the OpenSearch Service cluster nodes. This is `synonym_path` when the package is for synonym files.
     */
    public val referencePath: kotlin.String? = builder.referencePath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainPackageDetails(")
        append("associationConfiguration=$associationConfiguration,")
        append("domainName=$domainName,")
        append("domainPackageStatus=$domainPackageStatus,")
        append("errorDetails=$errorDetails,")
        append("lastUpdated=$lastUpdated,")
        append("packageId=$packageId,")
        append("packageName=$packageName,")
        append("packageType=$packageType,")
        append("packageVersion=$packageVersion,")
        append("prerequisitePackageIdList=$prerequisitePackageIdList,")
        append("referencePath=$referencePath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationConfiguration?.hashCode() ?: 0
        result = 31 * result + (this.domainName?.hashCode() ?: 0)
        result = 31 * result + (this.domainPackageStatus?.hashCode() ?: 0)
        result = 31 * result + (this.errorDetails?.hashCode() ?: 0)
        result = 31 * result + (this.lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (this.packageId?.hashCode() ?: 0)
        result = 31 * result + (this.packageName?.hashCode() ?: 0)
        result = 31 * result + (this.packageType?.hashCode() ?: 0)
        result = 31 * result + (this.packageVersion?.hashCode() ?: 0)
        result = 31 * result + (this.prerequisitePackageIdList?.hashCode() ?: 0)
        result = 31 * result + (this.referencePath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainPackageDetails

        if (associationConfiguration != other.associationConfiguration) return false
        if (domainName != other.domainName) return false
        if (domainPackageStatus != other.domainPackageStatus) return false
        if (errorDetails != other.errorDetails) return false
        if (lastUpdated != other.lastUpdated) return false
        if (packageId != other.packageId) return false
        if (packageName != other.packageName) return false
        if (packageType != other.packageType) return false
        if (packageVersion != other.packageVersion) return false
        if (prerequisitePackageIdList != other.prerequisitePackageIdList) return false
        if (referencePath != other.referencePath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for associating a package with an Amazon OpenSearch Service domain.
         */
        public var associationConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration? = null
        /**
         * Name of the domain that the package is associated with.
         */
        public var domainName: kotlin.String? = null
        /**
         * State of the association.
         */
        public var domainPackageStatus: aws.sdk.kotlin.services.opensearch.model.DomainPackageStatus? = null
        /**
         * Additional information if the package is in an error state. Null otherwise.
         */
        public var errorDetails: aws.sdk.kotlin.services.opensearch.model.ErrorDetails? = null
        /**
         * Timestamp of the most recent update to the package association status.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Internal ID of the package.
         */
        public var packageId: kotlin.String? = null
        /**
         * User-specified name of the package.
         */
        public var packageName: kotlin.String? = null
        /**
         * The type of package.
         */
        public var packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = null
        /**
         * The current version of the package.
         */
        public var packageVersion: kotlin.String? = null
        /**
         * A list of package IDs that must be associated with the domain before or with the package can be associated.
         */
        public var prerequisitePackageIdList: List<String>? = null
        /**
         * The relative path of the package on the OpenSearch Service cluster nodes. This is `synonym_path` when the package is for synonym files.
         */
        public var referencePath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails) : this() {
            this.associationConfiguration = x.associationConfiguration
            this.domainName = x.domainName
            this.domainPackageStatus = x.domainPackageStatus
            this.errorDetails = x.errorDetails
            this.lastUpdated = x.lastUpdated
            this.packageId = x.packageId
            this.packageName = x.packageName
            this.packageType = x.packageType
            this.packageVersion = x.packageVersion
            this.prerequisitePackageIdList = x.prerequisitePackageIdList
            this.referencePath = x.referencePath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = DomainPackageDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration] inside the given [block]
         */
        public fun associationConfiguration(block: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration.Builder.() -> kotlin.Unit) {
            this.associationConfiguration = awsSdkKotlinServicesOpensearchModelPackageAssociationConfigurationDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ErrorDetails] inside the given [block]
         */
        public fun errorDetails(block: aws.sdk.kotlin.services.opensearch.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.errorDetails = awsSdkKotlinServicesOpensearchModelErrorDetailsDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
