// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Options to configure a custom endpoint for an OpenSearch Service domain.
 */
public class DomainEndpointOptions private constructor(builder: Builder) {
    /**
     * The fully qualified URL for the custom endpoint.
     */
    public val customEndpoint: kotlin.String? = builder.customEndpoint
    /**
     * The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
     */
    public val customEndpointCertificateArn: kotlin.String? = builder.customEndpointCertificateArn
    /**
     * Whether to enable a custom endpoint for the domain.
     */
    public val customEndpointEnabled: kotlin.Boolean? = builder.customEndpointEnabled
    /**
     * True to require that all traffic to the domain arrive over HTTPS.
     */
    public val enforceHttps: kotlin.Boolean? = builder.enforceHttps
    /**
     * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the following values:
     * + **Policy-Min-TLS-1-0-2019-07:** TLS security policy that supports TLS version 1.0 to TLS version 1.2
     * + **Policy-Min-TLS-1-2-2019-07:** TLS security policy that supports only TLS version 1.2
     * + **Policy-Min-TLS-1-2-PFS-2023-10:** TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
     */
    public val tlsSecurityPolicy: aws.sdk.kotlin.services.opensearch.model.TlsSecurityPolicy? = builder.tlsSecurityPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainEndpointOptions(")
        append("customEndpoint=$customEndpoint,")
        append("customEndpointCertificateArn=$customEndpointCertificateArn,")
        append("customEndpointEnabled=$customEndpointEnabled,")
        append("enforceHttps=$enforceHttps,")
        append("tlsSecurityPolicy=$tlsSecurityPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customEndpoint?.hashCode() ?: 0
        result = 31 * result + (this.customEndpointCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (this.customEndpointEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.enforceHttps?.hashCode() ?: 0)
        result = 31 * result + (this.tlsSecurityPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainEndpointOptions

        if (customEndpoint != other.customEndpoint) return false
        if (customEndpointCertificateArn != other.customEndpointCertificateArn) return false
        if (customEndpointEnabled != other.customEndpointEnabled) return false
        if (enforceHttps != other.enforceHttps) return false
        if (tlsSecurityPolicy != other.tlsSecurityPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The fully qualified URL for the custom endpoint.
         */
        public var customEndpoint: kotlin.String? = null
        /**
         * The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
         */
        public var customEndpointCertificateArn: kotlin.String? = null
        /**
         * Whether to enable a custom endpoint for the domain.
         */
        public var customEndpointEnabled: kotlin.Boolean? = null
        /**
         * True to require that all traffic to the domain arrive over HTTPS.
         */
        public var enforceHttps: kotlin.Boolean? = null
        /**
         * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the following values:
         * + **Policy-Min-TLS-1-0-2019-07:** TLS security policy that supports TLS version 1.0 to TLS version 1.2
         * + **Policy-Min-TLS-1-2-2019-07:** TLS security policy that supports only TLS version 1.2
         * + **Policy-Min-TLS-1-2-PFS-2023-10:** TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
         */
        public var tlsSecurityPolicy: aws.sdk.kotlin.services.opensearch.model.TlsSecurityPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions) : this() {
            this.customEndpoint = x.customEndpoint
            this.customEndpointCertificateArn = x.customEndpointCertificateArn
            this.customEndpointEnabled = x.customEndpointEnabled
            this.enforceHttps = x.enforceHttps
            this.tlsSecurityPolicy = x.tlsSecurityPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = DomainEndpointOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
