// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.Document


public class CreateIndexRequest private constructor(builder: Builder) {
    /**
     * The name of an OpenSearch Service domain. Domain names are unique across the domains owned by an account within an Amazon Web Services Region.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The name of the index to create. Must be between 1 and 255 characters and follow OpenSearch naming conventions.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The JSON schema defining index mappings, settings, and semantic enrichment configuration. The schema specifies which text fields should be automatically enriched for semantic search capabilities and includes OpenSearch index configuration parameters.
     */
    public val indexSchema: aws.smithy.kotlin.runtime.content.Document? = builder.indexSchema

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.CreateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIndexRequest(")
        append("domainName=$domainName,")
        append("indexName=$indexName,")
        append("indexSchema=$indexSchema")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (this.indexName?.hashCode() ?: 0)
        result = 31 * result + (this.indexSchema?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIndexRequest

        if (domainName != other.domainName) return false
        if (indexName != other.indexName) return false
        if (indexSchema != other.indexSchema) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.CreateIndexRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an OpenSearch Service domain. Domain names are unique across the domains owned by an account within an Amazon Web Services Region.
         */
        public var domainName: kotlin.String? = null
        /**
         * The name of the index to create. Must be between 1 and 255 characters and follow OpenSearch naming conventions.
         */
        public var indexName: kotlin.String? = null
        /**
         * The JSON schema defining index mappings, settings, and semantic enrichment configuration. The schema specifies which text fields should be automatically enriched for semantic search capabilities and includes OpenSearch index configuration parameters.
         */
        public var indexSchema: aws.smithy.kotlin.runtime.content.Document? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.CreateIndexRequest) : this() {
            this.domainName = x.domainName
            this.indexName = x.indexName
            this.indexSchema = x.indexSchema
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.CreateIndexRequest = CreateIndexRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
