// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesOpensearchModelColdStorageOptionsDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions
private val awsSdkKotlinServicesOpensearchModelZoneAwarenessConfigDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig

/**
 * Container for the cluster configuration of an OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
 */
public class ClusterConfig private constructor(builder: Builder) {
    /**
     * Container for cold storage configuration options.
     */
    public val coldStorageOptions: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions? = builder.coldStorageOptions
    /**
     * Number of dedicated master nodes in the cluster. This number must be greater than 2 and not 4, otherwise you receive a validation exception.
     */
    public val dedicatedMasterCount: kotlin.Int? = builder.dedicatedMasterCount
    /**
     * Indicates whether dedicated master nodes are enabled for the cluster.`True` if the cluster will use a dedicated master node.`False` if the cluster will not.
     */
    public val dedicatedMasterEnabled: kotlin.Boolean? = builder.dedicatedMasterEnabled
    /**
     * OpenSearch Service instance type of the dedicated master nodes in the cluster.
     */
    public val dedicatedMasterType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.dedicatedMasterType
    /**
     * Number of data nodes in the cluster. This number must be greater than 1, otherwise you receive a validation exception.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Instance type of data nodes in the cluster.
     */
    public val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * A boolean that indicates whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
     */
    public val multiAzWithStandbyEnabled: kotlin.Boolean? = builder.multiAzWithStandbyEnabled
    /**
     * List of node options for the domain.
     */
    public val nodeOptions: List<NodeOption>? = builder.nodeOptions
    /**
     * The number of warm nodes in the cluster.
     */
    public val warmCount: kotlin.Int? = builder.warmCount
    /**
     * Whether to enable warm storage for the cluster.
     */
    public val warmEnabled: kotlin.Boolean? = builder.warmEnabled
    /**
     * The instance type for the cluster's warm nodes.
     */
    public val warmType: aws.sdk.kotlin.services.opensearch.model.OpenSearchWarmPartitionInstanceType? = builder.warmType
    /**
     * Container for zone awareness configuration options. Only required if `ZoneAwarenessEnabled` is `true`.
     */
    public val zoneAwarenessConfig: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig? = builder.zoneAwarenessConfig
    /**
     * Indicates whether multiple Availability Zones are enabled. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
     */
    public val zoneAwarenessEnabled: kotlin.Boolean? = builder.zoneAwarenessEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterConfig(")
        append("coldStorageOptions=$coldStorageOptions,")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("multiAzWithStandbyEnabled=$multiAzWithStandbyEnabled,")
        append("nodeOptions=$nodeOptions,")
        append("warmCount=$warmCount,")
        append("warmEnabled=$warmEnabled,")
        append("warmType=$warmType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = coldStorageOptions?.hashCode() ?: 0
        result = 31 * result + (this.dedicatedMasterCount ?: 0)
        result = 31 * result + (this.dedicatedMasterEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (this.instanceCount ?: 0)
        result = 31 * result + (this.instanceType?.hashCode() ?: 0)
        result = 31 * result + (this.multiAzWithStandbyEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.nodeOptions?.hashCode() ?: 0)
        result = 31 * result + (this.warmCount ?: 0)
        result = 31 * result + (this.warmEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.warmType?.hashCode() ?: 0)
        result = 31 * result + (this.zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (this.zoneAwarenessEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterConfig

        if (coldStorageOptions != other.coldStorageOptions) return false
        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (multiAzWithStandbyEnabled != other.multiAzWithStandbyEnabled) return false
        if (nodeOptions != other.nodeOptions) return false
        if (warmCount != other.warmCount) return false
        if (warmEnabled != other.warmEnabled) return false
        if (warmType != other.warmType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Container for cold storage configuration options.
         */
        public var coldStorageOptions: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions? = null
        /**
         * Number of dedicated master nodes in the cluster. This number must be greater than 2 and not 4, otherwise you receive a validation exception.
         */
        public var dedicatedMasterCount: kotlin.Int? = null
        /**
         * Indicates whether dedicated master nodes are enabled for the cluster.`True` if the cluster will use a dedicated master node.`False` if the cluster will not.
         */
        public var dedicatedMasterEnabled: kotlin.Boolean? = null
        /**
         * OpenSearch Service instance type of the dedicated master nodes in the cluster.
         */
        public var dedicatedMasterType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * Number of data nodes in the cluster. This number must be greater than 1, otherwise you receive a validation exception.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * Instance type of data nodes in the cluster.
         */
        public var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * A boolean that indicates whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
         */
        public var multiAzWithStandbyEnabled: kotlin.Boolean? = null
        /**
         * List of node options for the domain.
         */
        public var nodeOptions: List<NodeOption>? = null
        /**
         * The number of warm nodes in the cluster.
         */
        public var warmCount: kotlin.Int? = null
        /**
         * Whether to enable warm storage for the cluster.
         */
        public var warmEnabled: kotlin.Boolean? = null
        /**
         * The instance type for the cluster's warm nodes.
         */
        public var warmType: aws.sdk.kotlin.services.opensearch.model.OpenSearchWarmPartitionInstanceType? = null
        /**
         * Container for zone awareness configuration options. Only required if `ZoneAwarenessEnabled` is `true`.
         */
        public var zoneAwarenessConfig: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig? = null
        /**
         * Indicates whether multiple Availability Zones are enabled. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
         */
        public var zoneAwarenessEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ClusterConfig) : this() {
            this.coldStorageOptions = x.coldStorageOptions
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.multiAzWithStandbyEnabled = x.multiAzWithStandbyEnabled
            this.nodeOptions = x.nodeOptions
            this.warmCount = x.warmCount
            this.warmEnabled = x.warmEnabled
            this.warmType = x.warmType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = ClusterConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions] inside the given [block]
         */
        public fun coldStorageOptions(block: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions.Builder.() -> kotlin.Unit) {
            this.coldStorageOptions = awsSdkKotlinServicesOpensearchModelColdStorageOptionsDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig] inside the given [block]
         */
        public fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = awsSdkKotlinServicesOpensearchModelZoneAwarenessConfigDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
