// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Options for configuring Auto-Tune. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
 */
public class AutoTuneOptionsInput private constructor(builder: Builder) {
    /**
     * Whether Auto-Tune is enabled or disabled.
     */
    public val desiredState: aws.sdk.kotlin.services.opensearch.model.AutoTuneDesiredState? = builder.desiredState
    /**
     * A list of maintenance schedules during which Auto-Tune can deploy changes. Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html).
     */
    public val maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = builder.maintenanceSchedules
    /**
     * Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window.
     */
    public val useOffPeakWindow: kotlin.Boolean? = builder.useOffPeakWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoTuneOptionsInput(")
        append("desiredState=$desiredState,")
        append("maintenanceSchedules=$maintenanceSchedules,")
        append("useOffPeakWindow=$useOffPeakWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredState?.hashCode() ?: 0
        result = 31 * result + (this.maintenanceSchedules?.hashCode() ?: 0)
        result = 31 * result + (this.useOffPeakWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoTuneOptionsInput

        if (desiredState != other.desiredState) return false
        if (maintenanceSchedules != other.maintenanceSchedules) return false
        if (useOffPeakWindow != other.useOffPeakWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether Auto-Tune is enabled or disabled.
         */
        public var desiredState: aws.sdk.kotlin.services.opensearch.model.AutoTuneDesiredState? = null
        /**
         * A list of maintenance schedules during which Auto-Tune can deploy changes. Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html).
         */
        public var maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = null
        /**
         * Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window.
         */
        public var useOffPeakWindow: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsInput) : this() {
            this.desiredState = x.desiredState
            this.maintenanceSchedules = x.maintenanceSchedules
            this.useOffPeakWindow = x.useOffPeakWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsInput = AutoTuneOptionsInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
