// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


/**
 * Basic details of an OpenSearch application.
 */
public class ApplicationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when an OpenSearch application was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The endpoint URL of an OpenSearch application.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The unique identifier of an OpenSearch application.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The timestamp of the last update to an OpenSearch application.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of an OpenSearch application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of an OpenSearch application. Possible values: `CREATING`, `UPDATING`, `DELETING`, `FAILED`, `ACTIVE`, and `DELETED`.
     */
    public val status: aws.sdk.kotlin.services.opensearch.model.ApplicationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ApplicationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (this.createdAt?.hashCode() ?: 0)
        result = 31 * result + (this.endpoint?.hashCode() ?: 0)
        result = 31 * result + (this.id?.hashCode() ?: 0)
        result = 31 * result + (this.lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ApplicationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when an OpenSearch application was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoint URL of an OpenSearch application.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The unique identifier of an OpenSearch application.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp of the last update to an OpenSearch application.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of an OpenSearch application.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of an OpenSearch application. Possible values: `CREATING`, `UPDATING`, `DELETING`, `FAILED`, `ACTIVE`, and `DELETED`.
         */
        public var status: aws.sdk.kotlin.services.opensearch.model.ApplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ApplicationSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.endpoint = x.endpoint
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ApplicationSummary = ApplicationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
