// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesOpensearchModelOptionStatusDslBuilderRef = aws.sdk.kotlin.services.opensearch.model.OptionStatus

/**
 * Status of the advanced options for the specified domain. The following options are available:
 * + `"rest.action.multi.allow_explicit_index": "true" | "false"` - Note the use of a string rather than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you want to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must disable this property. Default is true.
 * + `"indices.fielddata.cache.size": "80" ` - Note the use of a string rather than a boolean. Specifies the percentage of heap space allocated to field data. Default is unbounded.
 * + `"indices.query.bool.max_clause_count": "1024"` - Note the use of a string rather than a boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more than the permitted number of clauses result in a `TooManyClauses` error.
 * + `"override_main_response_version": "true" | "false"` - Note the use of a string rather than a boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and plugins to continue working with it. Default is false when creating a domain and true when upgrading a domain.
 *
 * For more information, see [Advanced cluster parameters](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
 */
public class AdvancedOptionsStatus private constructor(builder: Builder) {
    /**
     * The status of advanced options for the specified domain.
     */
    public val options: Map<String, String> = requireNotNull(builder.options) { "A non-null value must be provided for options" }
    /**
     * The status of advanced options for the specified domain.
     */
    public val status: aws.sdk.kotlin.services.opensearch.model.OptionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedOptionsStatus(")
        append("options=$options,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = options.hashCode()
        result = 31 * result + (this.status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedOptionsStatus

        if (options != other.options) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of advanced options for the specified domain.
         */
        public var options: Map<String, String>? = null
        /**
         * The status of advanced options for the specified domain.
         */
        public var status: aws.sdk.kotlin.services.opensearch.model.OptionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus) : this() {
            this.options = x.options
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus = AdvancedOptionsStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.OptionStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.opensearch.model.OptionStatus.Builder.() -> kotlin.Unit) {
            this.status = awsSdkKotlinServicesOpensearchModelOptionStatusDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (options == null) options = emptyMap()
            return this
        }
    }
}
