// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.opensearch.auth.DefaultOpenSearchAuthSchemeProvider
import aws.sdk.kotlin.services.opensearch.auth.OpenSearchAuthSchemeProvider
import aws.sdk.kotlin.services.opensearch.endpoints.DefaultOpenSearchEndpointProvider
import aws.sdk.kotlin.services.opensearch.endpoints.OpenSearchEndpointParameters
import aws.sdk.kotlin.services.opensearch.endpoints.OpenSearchEndpointProvider
import aws.sdk.kotlin.services.opensearch.model.AcceptInboundConnectionRequest
import aws.sdk.kotlin.services.opensearch.model.AcceptInboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.AddDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.AddDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.AddDirectQueryDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.AddDirectQueryDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.AddTagsRequest
import aws.sdk.kotlin.services.opensearch.model.AddTagsResponse
import aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.AssociatePackageResponse
import aws.sdk.kotlin.services.opensearch.model.AssociatePackagesRequest
import aws.sdk.kotlin.services.opensearch.model.AssociatePackagesResponse
import aws.sdk.kotlin.services.opensearch.model.AuthorizeVpcEndpointAccessRequest
import aws.sdk.kotlin.services.opensearch.model.AuthorizeVpcEndpointAccessResponse
import aws.sdk.kotlin.services.opensearch.model.CancelDomainConfigChangeRequest
import aws.sdk.kotlin.services.opensearch.model.CancelDomainConfigChangeResponse
import aws.sdk.kotlin.services.opensearch.model.CancelServiceSoftwareUpdateRequest
import aws.sdk.kotlin.services.opensearch.model.CancelServiceSoftwareUpdateResponse
import aws.sdk.kotlin.services.opensearch.model.CreateApplicationRequest
import aws.sdk.kotlin.services.opensearch.model.CreateApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.CreateDomainRequest
import aws.sdk.kotlin.services.opensearch.model.CreateDomainResponse
import aws.sdk.kotlin.services.opensearch.model.CreateIndexRequest
import aws.sdk.kotlin.services.opensearch.model.CreateIndexResponse
import aws.sdk.kotlin.services.opensearch.model.CreateOutboundConnectionRequest
import aws.sdk.kotlin.services.opensearch.model.CreateOutboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.CreatePackageResponse
import aws.sdk.kotlin.services.opensearch.model.CreateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearch.model.CreateVpcEndpointResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteDirectQueryDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteDirectQueryDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteDomainRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteDomainResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteInboundConnectionRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteInboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteIndexRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteIndexResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteOutboundConnectionRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteOutboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.DeletePackageRequest
import aws.sdk.kotlin.services.opensearch.model.DeletePackageResponse
import aws.sdk.kotlin.services.opensearch.model.DeleteVpcEndpointRequest
import aws.sdk.kotlin.services.opensearch.model.DeleteVpcEndpointResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainChangeProgressRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainChangeProgressResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainConfigRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainConfigResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainNodesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainNodesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeDryRunProgressRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDryRunProgressResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeVpcEndpointsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeVpcEndpointsResponse
import aws.sdk.kotlin.services.opensearch.model.DissociatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.DissociatePackageResponse
import aws.sdk.kotlin.services.opensearch.model.DissociatePackagesRequest
import aws.sdk.kotlin.services.opensearch.model.DissociatePackagesResponse
import aws.sdk.kotlin.services.opensearch.model.GetApplicationRequest
import aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.GetCompatibleVersionsRequest
import aws.sdk.kotlin.services.opensearch.model.GetCompatibleVersionsResponse
import aws.sdk.kotlin.services.opensearch.model.GetDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.GetDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.GetDefaultApplicationSettingRequest
import aws.sdk.kotlin.services.opensearch.model.GetDefaultApplicationSettingResponse
import aws.sdk.kotlin.services.opensearch.model.GetDirectQueryDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.GetDirectQueryDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.GetDomainMaintenanceStatusRequest
import aws.sdk.kotlin.services.opensearch.model.GetDomainMaintenanceStatusResponse
import aws.sdk.kotlin.services.opensearch.model.GetIndexRequest
import aws.sdk.kotlin.services.opensearch.model.GetIndexResponse
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeStatusRequest
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeStatusResponse
import aws.sdk.kotlin.services.opensearch.model.ListApplicationsRequest
import aws.sdk.kotlin.services.opensearch.model.ListApplicationsResponse
import aws.sdk.kotlin.services.opensearch.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.opensearch.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.opensearch.model.ListDirectQueryDataSourcesRequest
import aws.sdk.kotlin.services.opensearch.model.ListDirectQueryDataSourcesResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainMaintenancesRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainMaintenancesResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainNamesResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageResponse
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsRequest
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsResponse
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainResponse
import aws.sdk.kotlin.services.opensearch.model.ListScheduledActionsRequest
import aws.sdk.kotlin.services.opensearch.model.ListScheduledActionsResponse
import aws.sdk.kotlin.services.opensearch.model.ListTagsRequest
import aws.sdk.kotlin.services.opensearch.model.ListTagsResponse
import aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest
import aws.sdk.kotlin.services.opensearch.model.ListVersionsResponse
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointAccessRequest
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointAccessResponse
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointsForDomainRequest
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointsForDomainResponse
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointsRequest
import aws.sdk.kotlin.services.opensearch.model.ListVpcEndpointsResponse
import aws.sdk.kotlin.services.opensearch.model.PurchaseReservedInstanceOfferingRequest
import aws.sdk.kotlin.services.opensearch.model.PurchaseReservedInstanceOfferingResponse
import aws.sdk.kotlin.services.opensearch.model.PutDefaultApplicationSettingRequest
import aws.sdk.kotlin.services.opensearch.model.PutDefaultApplicationSettingResponse
import aws.sdk.kotlin.services.opensearch.model.RejectInboundConnectionRequest
import aws.sdk.kotlin.services.opensearch.model.RejectInboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.RemoveTagsRequest
import aws.sdk.kotlin.services.opensearch.model.RemoveTagsResponse
import aws.sdk.kotlin.services.opensearch.model.RevokeVpcEndpointAccessRequest
import aws.sdk.kotlin.services.opensearch.model.RevokeVpcEndpointAccessResponse
import aws.sdk.kotlin.services.opensearch.model.StartDomainMaintenanceRequest
import aws.sdk.kotlin.services.opensearch.model.StartDomainMaintenanceResponse
import aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateRequest
import aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateDirectQueryDataSourceRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateDirectQueryDataSourceResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateIndexRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateIndexResponse
import aws.sdk.kotlin.services.opensearch.model.UpdatePackageRequest
import aws.sdk.kotlin.services.opensearch.model.UpdatePackageResponse
import aws.sdk.kotlin.services.opensearch.model.UpdatePackageScopeRequest
import aws.sdk.kotlin.services.opensearch.model.UpdatePackageScopeResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateScheduledActionResponse
import aws.sdk.kotlin.services.opensearch.model.UpdateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearch.model.UpdateVpcEndpointResponse
import aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest
import aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "OpenSearch"
public const val SdkVersion: String = "1.5.84"
public const val ServiceApiVersion: String = "2021-01-01"

/**
 * Use the Amazon OpenSearch Service configuration API to create, configure, and manage OpenSearch Service domains. The endpoint for configuration service requests is Region specific: es.*region*.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported Regions and endpoints, see [Amazon Web Services service endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions).
 */
public interface OpenSearchClient : SdkClient {
    /**
     * OpenSearchClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, OpenSearchClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "OpenSearch",
                "OPENSEARCH",
                "opensearch",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, OpenSearchClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): OpenSearchClient = DefaultOpenSearchClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: OpenSearchEndpointProvider = builder.endpointProvider ?: DefaultOpenSearchEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: OpenSearchAuthSchemeProvider = builder.authSchemeProvider ?: DefaultOpenSearchAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "OpenSearch"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: OpenSearchEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: OpenSearchAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search connection request. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun acceptInboundConnection(input: AcceptInboundConnectionRequest): AcceptInboundConnectionResponse

    /**
     * Creates a new direct-query data source to the specified domain. For more information, see [Creating Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
     */
    public suspend fun addDataSource(input: AddDataSourceRequest): AddDataSourceResponse

    /**
     * Adds a new data source in Amazon OpenSearch Service so that you can perform direct queries on external data.
     */
    public suspend fun addDirectQueryDataSource(input: AddDirectQueryDataSourceRequest): AddDirectQueryDataSourceResponse

    /**
     * Attaches tags to an existing Amazon OpenSearch Service domain, data source, or application.
     *
     * Tags are a set of case-sensitive key-value pairs. A domain, data source, or application can have up to 10 tags. For more information, see [Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Associates a package with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse

    /**
     * Operation in the Amazon OpenSearch Service API for associating multiple packages with a domain simultaneously.
     */
    public suspend fun associatePackages(input: AssociatePackagesRequest): AssociatePackagesResponse

    /**
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    public suspend fun authorizeVpcEndpointAccess(input: AuthorizeVpcEndpointAccessRequest): AuthorizeVpcEndpointAccessResponse

    /**
     * Cancels a pending configuration change on an Amazon OpenSearch Service domain.
     */
    public suspend fun cancelDomainConfigChange(input: CancelDomainConfigChangeRequest): CancelDomainConfigChangeResponse

    /**
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the domain's `UpdateStatus` is `PENDING_UPDATE`. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
     */
    public suspend fun cancelServiceSoftwareUpdate(input: CancelServiceSoftwareUpdateRequest): CancelServiceSoftwareUpdateResponse

    /**
     * Creates an OpenSearch UI application. For more information, see [Using the OpenSearch user interface in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html).
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates an OpenSearch index with optional automatic semantic enrichment for specified text fields. Automatic semantic enrichment enables semantic search capabilities without requiring machine learning expertise, improving search relevance by up to 20% by understanding search intent and contextual meaning beyond keyword matching. The semantic enrichment process has zero impact on search latency as sparse encodings are stored directly within the index during indexing. For more information, see [Automatic semantic enrichment](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-semantic-enrichment.html).
     */
    public suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun createOutboundConnection(input: CreateOutboundConnectionRequest): CreateOutboundConnectionResponse

    /**
     * Creates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse

    /**
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     */
    public suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse

    /**
     * Deletes a specified OpenSearch application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes a direct-query data source. For more information, see [Deleting an Amazon OpenSearch Service data source with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html).
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a previously configured direct query data source from Amazon OpenSearch Service.
     */
    public suspend fun deleteDirectQueryDataSource(input: DeleteDirectQueryDataSourceRequest): DeleteDirectQueryDataSourceResponse

    /**
     * Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun deleteInboundConnection(input: DeleteInboundConnectionRequest): DeleteInboundConnectionResponse

    /**
     * Deletes an OpenSearch index. This operation permanently removes the index and cannot be undone.
     */
    public suspend fun deleteIndex(input: DeleteIndexRequest): DeleteIndexResponse

    /**
     * Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun deleteOutboundConnection(input: DeleteOutboundConnectionRequest): DeleteOutboundConnectionResponse

    /**
     * Deletes an Amazon OpenSearch Service package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    public suspend fun deleteVpcEndpoint(input: DeleteVpcEndpointRequest): DeleteVpcEndpointResponse

    /**
     * Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID, domain service endpoint, and domain ARN.
     */
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
     */
    public suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse

    /**
     * Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For more information, see [Making configuration changes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html).
     */
    public suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse

    /**
     * Returns the configuration of an Amazon OpenSearch Service domain.
     */
    public suspend fun describeDomainConfig(input: DescribeDomainConfigRequest): DescribeDomainConfigResponse

    /**
     * Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability Zone, and shard count per node.
     */
    public suspend fun describeDomainHealth(input: DescribeDomainHealthRequest): DescribeDomainHealthResponse

    /**
     * Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node configurations, and node states.
     */
    public suspend fun describeDomainNodes(input: DescribeDomainNodesRequest): DescribeDomainNodesResponse

    /**
     * Returns domain configuration information about the specified Amazon OpenSearch Service domains.
     */
    public suspend fun describeDomains(input: DescribeDomainsRequest): DescribeDomainsResponse

    /**
     * Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more information, see [Determining whether a change will cause a blue/green deployment](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun).
     */
    public suspend fun describeDryRunProgress(input: DescribeDryRunProgressRequest): DescribeDryRunProgressResponse

    /**
     * Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun describeInboundConnections(input: DescribeInboundConnectionsRequest = DescribeInboundConnectionsRequest { }): DescribeInboundConnectionsResponse

    /**
     * Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and instance type.
     */
    public suspend fun describeInstanceTypeLimits(input: DescribeInstanceTypeLimitsRequest): DescribeInstanceTypeLimitsResponse

    /**
     * Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
     */
    public suspend fun describeOutboundConnections(input: DescribeOutboundConnectionsRequest = DescribeOutboundConnectionsRequest { }): DescribeOutboundConnectionsResponse

    /**
     * Describes all packages available to OpenSearch Service. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun describePackages(input: DescribePackagesRequest = DescribePackagesRequest { }): DescribePackagesResponse

    /**
     * Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
     */
    public suspend fun describeReservedInstanceOfferings(input: DescribeReservedInstanceOfferingsRequest = DescribeReservedInstanceOfferingsRequest { }): DescribeReservedInstanceOfferingsResponse

    /**
     * Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
     */
    public suspend fun describeReservedInstances(input: DescribeReservedInstancesRequest = DescribeReservedInstancesRequest { }): DescribeReservedInstancesResponse

    /**
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     */
    public suspend fun describeVpcEndpoints(input: DescribeVpcEndpointsRequest): DescribeVpcEndpointsResponse

    /**
     * Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for association later. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse

    /**
     * Dissociates multiple packages from a domain simultaneously.
     */
    public suspend fun dissociatePackages(input: DissociatePackagesRequest): DissociatePackagesResponse

    /**
     * Retrieves the configuration and status of an existing OpenSearch application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     */
    public suspend fun getCompatibleVersions(input: GetCompatibleVersionsRequest = GetCompatibleVersionsRequest { }): GetCompatibleVersionsResponse

    /**
     * Retrieves information about a direct query data source.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Gets the ARN of the current default application.
     *
     *  If the default application isn't set, the operation returns a resource not found error.
     */
    public suspend fun getDefaultApplicationSetting(input: GetDefaultApplicationSettingRequest = GetDefaultApplicationSettingRequest { }): GetDefaultApplicationSettingResponse

    /**
     * Returns detailed configuration information for a specific direct query data source in Amazon OpenSearch Service.
     */
    public suspend fun getDirectQueryDataSource(input: GetDirectQueryDataSourceRequest): GetDirectQueryDataSourceResponse

    /**
     * The status of the maintenance action.
     */
    public suspend fun getDomainMaintenanceStatus(input: GetDomainMaintenanceStatusRequest): GetDomainMaintenanceStatusResponse

    /**
     * Retrieves information about an OpenSearch index including its schema and semantic enrichment configuration. Use this operation to view the current index structure and semantic search settings.
     */
    public suspend fun getIndex(input: GetIndexRequest): GetIndexResponse

    /**
     * Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and plugin properties (if the package is a zip plugin package). For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse

    /**
     * Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
     */
    public suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse

    /**
     * Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch Service domain.
     */
    public suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse

    /**
     * Lists all OpenSearch applications under your account.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists direct-query data sources for a specific domain. For more information, see For more information, see [Working with Amazon OpenSearch Service direct queries with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html).
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists an inventory of all the direct query data sources that you have configured within Amazon OpenSearch Service.
     */
    public suspend fun listDirectQueryDataSources(input: ListDirectQueryDataSourcesRequest = ListDirectQueryDataSourcesRequest { }): ListDirectQueryDataSourcesResponse

    /**
     * A list of maintenance actions for the domain.
     */
    public suspend fun listDomainMaintenances(input: ListDomainMaintenancesRequest): ListDomainMaintenancesResponse

    /**
     * Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
     */
    public suspend fun listDomainNames(input: ListDomainNamesRequest = ListDomainNamesRequest { }): ListDomainNamesResponse

    /**
     * Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse

    /**
     * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
     */
    public suspend fun listInstanceTypeDetails(input: ListInstanceTypeDetailsRequest): ListInstanceTypeDetailsResponse

    /**
     * Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse

    /**
     * Retrieves a list of configuration changes that are scheduled for a domain. These changes can be [service software updates](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or [blue/green Auto-Tune enhancements](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
     */
    public suspend fun listScheduledActions(input: ListScheduledActionsRequest): ListScheduledActionsResponse

    /**
     * Returns all resource tags for an Amazon OpenSearch Service domain, data source, or application. For more information, see [Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
     */
    public suspend fun listVersions(input: ListVersionsRequest = ListVersionsRequest { }): ListVersionsResponse

    /**
     * Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    public suspend fun listVpcEndpointAccess(input: ListVpcEndpointAccessRequest): ListVpcEndpointAccessResponse

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and Region.
     */
    public suspend fun listVpcEndpoints(input: ListVpcEndpointsRequest = ListVpcEndpointsRequest { }): ListVpcEndpointsResponse

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     */
    public suspend fun listVpcEndpointsForDomain(input: ListVpcEndpointsForDomainRequest): ListVpcEndpointsForDomainResponse

    /**
     * Allows you to purchase Amazon OpenSearch Service Reserved Instances.
     */
    public suspend fun purchaseReservedInstanceOffering(input: PurchaseReservedInstanceOfferingRequest): PurchaseReservedInstanceOfferingResponse

    /**
     * Sets the default application to the application with the specified ARN.
     *
     *  To remove the default application, use the `GetDefaultApplicationSetting` operation to get the current default and then call the `PutDefaultApplicationSetting` with the current applications ARN and the `setAsDefault` parameter set to `false`.
     */
    public suspend fun putDefaultApplicationSetting(input: PutDefaultApplicationSettingRequest): PutDefaultApplicationSettingResponse

    /**
     * Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
     */
    public suspend fun rejectInboundConnection(input: RejectInboundConnectionRequest): RejectInboundConnectionResponse

    /**
     * Removes the specified set of tags from an Amazon OpenSearch Service domain, data source, or application. For more information, see [ Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging).
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     */
    public suspend fun revokeVpcEndpointAccess(input: RevokeVpcEndpointAccessRequest): RevokeVpcEndpointAccessResponse

    /**
     * Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or Elasticsearch process restart, or a Dashboard or Kibana restart.
     */
    public suspend fun startDomainMaintenance(input: StartDomainMaintenanceRequest): StartDomainMaintenanceResponse

    /**
     * Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
     */
    public suspend fun startServiceSoftwareUpdate(input: StartServiceSoftwareUpdateRequest): StartServiceSoftwareUpdateResponse

    /**
     * Updates the configuration and settings of an existing OpenSearch application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates a direct-query data source. For more information, see [Working with Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates the configuration or properties of an existing direct query data source in Amazon OpenSearch Service.
     */
    public suspend fun updateDirectQueryDataSource(input: UpdateDirectQueryDataSourceRequest): UpdateDirectQueryDataSourceResponse

    /**
     * Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
     */
    public suspend fun updateDomainConfig(input: UpdateDomainConfigRequest): UpdateDomainConfigResponse

    /**
     * Updates an existing OpenSearch index schema and semantic enrichment configuration. This operation allows modification of field mappings and semantic search settings for text fields. Changes to semantic enrichment configuration will apply to newly ingested documents.
     */
    public suspend fun updateIndex(input: UpdateIndexRequest): UpdateIndexResponse

    /**
     * Updates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
     */
    public suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse

    /**
     * Updates the scope of a package. Scope of the package defines users who can view and associate a package.
     */
    public suspend fun updatePackageScope(input: UpdatePackageScopeRequest): UpdatePackageScopeResponse

    /**
     * Reschedules a planned domain configuration change for a later time. This change can be a scheduled [service software update](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or a [blue/green Auto-Tune enhancement](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
     */
    public suspend fun updateScheduledAction(input: UpdateScheduledActionRequest): UpdateScheduledActionResponse

    /**
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    public suspend fun updateVpcEndpoint(input: UpdateVpcEndpointRequest): UpdateVpcEndpointResponse

    /**
     * Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
     */
    public suspend fun upgradeDomain(input: UpgradeDomainRequest): UpgradeDomainResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun OpenSearchClient.withConfig(block: OpenSearchClient.Config.Builder.() -> Unit): OpenSearchClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultOpenSearchClient(newConfig)
}

/**
 * Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search connection request. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.acceptInboundConnection(crossinline block: AcceptInboundConnectionRequest.Builder.() -> Unit): AcceptInboundConnectionResponse = acceptInboundConnection(AcceptInboundConnectionRequest.Builder().apply(block).build())

/**
 * Creates a new direct-query data source to the specified domain. For more information, see [Creating Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
 */
public suspend inline fun OpenSearchClient.addDataSource(crossinline block: AddDataSourceRequest.Builder.() -> Unit): AddDataSourceResponse = addDataSource(AddDataSourceRequest.Builder().apply(block).build())

/**
 * Adds a new data source in Amazon OpenSearch Service so that you can perform direct queries on external data.
 */
public suspend inline fun OpenSearchClient.addDirectQueryDataSource(crossinline block: AddDirectQueryDataSourceRequest.Builder.() -> Unit): AddDirectQueryDataSourceResponse = addDirectQueryDataSource(AddDirectQueryDataSourceRequest.Builder().apply(block).build())

/**
 * Attaches tags to an existing Amazon OpenSearch Service domain, data source, or application.
 *
 * Tags are a set of case-sensitive key-value pairs. A domain, data source, or application can have up to 10 tags. For more information, see [Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
 */
public suspend inline fun OpenSearchClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Associates a package with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.associatePackage(crossinline block: AssociatePackageRequest.Builder.() -> Unit): AssociatePackageResponse = associatePackage(AssociatePackageRequest.Builder().apply(block).build())

/**
 * Operation in the Amazon OpenSearch Service API for associating multiple packages with a domain simultaneously.
 */
public suspend inline fun OpenSearchClient.associatePackages(crossinline block: AssociatePackagesRequest.Builder.() -> Unit): AssociatePackagesResponse = associatePackages(AssociatePackagesRequest.Builder().apply(block).build())

/**
 * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
 */
public suspend inline fun OpenSearchClient.authorizeVpcEndpointAccess(crossinline block: AuthorizeVpcEndpointAccessRequest.Builder.() -> Unit): AuthorizeVpcEndpointAccessResponse = authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Cancels a pending configuration change on an Amazon OpenSearch Service domain.
 */
public suspend inline fun OpenSearchClient.cancelDomainConfigChange(crossinline block: CancelDomainConfigChangeRequest.Builder.() -> Unit): CancelDomainConfigChangeResponse = cancelDomainConfigChange(CancelDomainConfigChangeRequest.Builder().apply(block).build())

/**
 * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the domain's `UpdateStatus` is `PENDING_UPDATE`. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
 */
public suspend inline fun OpenSearchClient.cancelServiceSoftwareUpdate(crossinline block: CancelServiceSoftwareUpdateRequest.Builder.() -> Unit): CancelServiceSoftwareUpdateResponse = cancelServiceSoftwareUpdate(CancelServiceSoftwareUpdateRequest.Builder().apply(block).build())

/**
 * Creates an OpenSearch UI application. For more information, see [Using the OpenSearch user interface in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html).
 */
public suspend inline fun OpenSearchClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
 */
public suspend inline fun OpenSearchClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Creates an OpenSearch index with optional automatic semantic enrichment for specified text fields. Automatic semantic enrichment enables semantic search capabilities without requiring machine learning expertise, improving search relevance by up to 20% by understanding search intent and contextual meaning beyond keyword matching. The semantic enrichment process has zero impact on search latency as sparse encodings are stored directly within the index during indexing. For more information, see [Automatic semantic enrichment](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-semantic-enrichment.html).
 */
public suspend inline fun OpenSearchClient.createIndex(crossinline block: CreateIndexRequest.Builder.() -> Unit): CreateIndexResponse = createIndex(CreateIndexRequest.Builder().apply(block).build())

/**
 * Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.createOutboundConnection(crossinline block: CreateOutboundConnectionRequest.Builder.() -> Unit): CreateOutboundConnectionResponse = createOutboundConnection(CreateOutboundConnectionRequest.Builder().apply(block).build())

/**
 * Creates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.createPackage(crossinline block: CreatePackageRequest.Builder.() -> Unit): CreatePackageResponse = createPackage(CreatePackageRequest.Builder().apply(block).build())

/**
 * Creates an Amazon OpenSearch Service-managed VPC endpoint.
 */
public suspend inline fun OpenSearchClient.createVpcEndpoint(crossinline block: CreateVpcEndpointRequest.Builder.() -> Unit): CreateVpcEndpointResponse = createVpcEndpoint(CreateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a specified OpenSearch application.
 */
public suspend inline fun OpenSearchClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a direct-query data source. For more information, see [Deleting an Amazon OpenSearch Service data source with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html).
 */
public suspend inline fun OpenSearchClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a previously configured direct query data source from Amazon OpenSearch Service.
 */
public suspend inline fun OpenSearchClient.deleteDirectQueryDataSource(crossinline block: DeleteDirectQueryDataSourceRequest.Builder.() -> Unit): DeleteDirectQueryDataSourceResponse = deleteDirectQueryDataSource(DeleteDirectQueryDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
 */
public suspend inline fun OpenSearchClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.deleteInboundConnection(crossinline block: DeleteInboundConnectionRequest.Builder.() -> Unit): DeleteInboundConnectionResponse = deleteInboundConnection(DeleteInboundConnectionRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch index. This operation permanently removes the index and cannot be undone.
 */
public suspend inline fun OpenSearchClient.deleteIndex(crossinline block: DeleteIndexRequest.Builder.() -> Unit): DeleteIndexResponse = deleteIndex(DeleteIndexRequest.Builder().apply(block).build())

/**
 * Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.deleteOutboundConnection(crossinline block: DeleteOutboundConnectionRequest.Builder.() -> Unit): DeleteOutboundConnectionResponse = deleteOutboundConnection(DeleteOutboundConnectionRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon OpenSearch Service package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.deletePackage(crossinline block: DeletePackageRequest.Builder.() -> Unit): DeletePackageResponse = deletePackage(DeletePackageRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
 */
public suspend inline fun OpenSearchClient.deleteVpcEndpoint(crossinline block: DeleteVpcEndpointRequest.Builder.() -> Unit): DeleteVpcEndpointResponse = deleteVpcEndpoint(DeleteVpcEndpointRequest.Builder().apply(block).build())

/**
 * Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID, domain service endpoint, and domain ARN.
 */
public suspend inline fun OpenSearchClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
 */
public suspend inline fun OpenSearchClient.describeDomainAutoTunes(crossinline block: DescribeDomainAutoTunesRequest.Builder.() -> Unit): DescribeDomainAutoTunesResponse = describeDomainAutoTunes(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

/**
 * Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For more information, see [Making configuration changes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html).
 */
public suspend inline fun OpenSearchClient.describeDomainChangeProgress(crossinline block: DescribeDomainChangeProgressRequest.Builder.() -> Unit): DescribeDomainChangeProgressResponse = describeDomainChangeProgress(DescribeDomainChangeProgressRequest.Builder().apply(block).build())

/**
 * Returns the configuration of an Amazon OpenSearch Service domain.
 */
public suspend inline fun OpenSearchClient.describeDomainConfig(crossinline block: DescribeDomainConfigRequest.Builder.() -> Unit): DescribeDomainConfigResponse = describeDomainConfig(DescribeDomainConfigRequest.Builder().apply(block).build())

/**
 * Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability Zone, and shard count per node.
 */
public suspend inline fun OpenSearchClient.describeDomainHealth(crossinline block: DescribeDomainHealthRequest.Builder.() -> Unit): DescribeDomainHealthResponse = describeDomainHealth(DescribeDomainHealthRequest.Builder().apply(block).build())

/**
 * Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node configurations, and node states.
 */
public suspend inline fun OpenSearchClient.describeDomainNodes(crossinline block: DescribeDomainNodesRequest.Builder.() -> Unit): DescribeDomainNodesResponse = describeDomainNodes(DescribeDomainNodesRequest.Builder().apply(block).build())

/**
 * Returns domain configuration information about the specified Amazon OpenSearch Service domains.
 */
public suspend inline fun OpenSearchClient.describeDomains(crossinline block: DescribeDomainsRequest.Builder.() -> Unit): DescribeDomainsResponse = describeDomains(DescribeDomainsRequest.Builder().apply(block).build())

/**
 * Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more information, see [Determining whether a change will cause a blue/green deployment](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun).
 */
public suspend inline fun OpenSearchClient.describeDryRunProgress(crossinline block: DescribeDryRunProgressRequest.Builder.() -> Unit): DescribeDryRunProgressResponse = describeDryRunProgress(DescribeDryRunProgressRequest.Builder().apply(block).build())

/**
 * Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.describeInboundConnections(crossinline block: DescribeInboundConnectionsRequest.Builder.() -> Unit): DescribeInboundConnectionsResponse = describeInboundConnections(DescribeInboundConnectionsRequest.Builder().apply(block).build())

/**
 * Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and instance type.
 */
public suspend inline fun OpenSearchClient.describeInstanceTypeLimits(crossinline block: DescribeInstanceTypeLimitsRequest.Builder.() -> Unit): DescribeInstanceTypeLimitsResponse = describeInstanceTypeLimits(DescribeInstanceTypeLimitsRequest.Builder().apply(block).build())

/**
 * Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
 */
public suspend inline fun OpenSearchClient.describeOutboundConnections(crossinline block: DescribeOutboundConnectionsRequest.Builder.() -> Unit): DescribeOutboundConnectionsResponse = describeOutboundConnections(DescribeOutboundConnectionsRequest.Builder().apply(block).build())

/**
 * Describes all packages available to OpenSearch Service. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.describePackages(crossinline block: DescribePackagesRequest.Builder.() -> Unit): DescribePackagesResponse = describePackages(DescribePackagesRequest.Builder().apply(block).build())

/**
 * Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
 */
public suspend inline fun OpenSearchClient.describeReservedInstanceOfferings(crossinline block: DescribeReservedInstanceOfferingsRequest.Builder.() -> Unit): DescribeReservedInstanceOfferingsResponse = describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsRequest.Builder().apply(block).build())

/**
 * Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
 */
public suspend inline fun OpenSearchClient.describeReservedInstances(crossinline block: DescribeReservedInstancesRequest.Builder.() -> Unit): DescribeReservedInstancesResponse = describeReservedInstances(DescribeReservedInstancesRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
 */
public suspend inline fun OpenSearchClient.describeVpcEndpoints(crossinline block: DescribeVpcEndpointsRequest.Builder.() -> Unit): DescribeVpcEndpointsResponse = describeVpcEndpoints(DescribeVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for association later. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.dissociatePackage(crossinline block: DissociatePackageRequest.Builder.() -> Unit): DissociatePackageResponse = dissociatePackage(DissociatePackageRequest.Builder().apply(block).build())

/**
 * Dissociates multiple packages from a domain simultaneously.
 */
public suspend inline fun OpenSearchClient.dissociatePackages(crossinline block: DissociatePackagesRequest.Builder.() -> Unit): DissociatePackagesResponse = dissociatePackages(DissociatePackagesRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration and status of an existing OpenSearch application.
 */
public suspend inline fun OpenSearchClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
 */
public suspend inline fun OpenSearchClient.getCompatibleVersions(crossinline block: GetCompatibleVersionsRequest.Builder.() -> Unit): GetCompatibleVersionsResponse = getCompatibleVersions(GetCompatibleVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about a direct query data source.
 */
public suspend inline fun OpenSearchClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Gets the ARN of the current default application.
 *
 *  If the default application isn't set, the operation returns a resource not found error.
 */
public suspend inline fun OpenSearchClient.getDefaultApplicationSetting(crossinline block: GetDefaultApplicationSettingRequest.Builder.() -> Unit): GetDefaultApplicationSettingResponse = getDefaultApplicationSetting(GetDefaultApplicationSettingRequest.Builder().apply(block).build())

/**
 * Returns detailed configuration information for a specific direct query data source in Amazon OpenSearch Service.
 */
public suspend inline fun OpenSearchClient.getDirectQueryDataSource(crossinline block: GetDirectQueryDataSourceRequest.Builder.() -> Unit): GetDirectQueryDataSourceResponse = getDirectQueryDataSource(GetDirectQueryDataSourceRequest.Builder().apply(block).build())

/**
 * The status of the maintenance action.
 */
public suspend inline fun OpenSearchClient.getDomainMaintenanceStatus(crossinline block: GetDomainMaintenanceStatusRequest.Builder.() -> Unit): GetDomainMaintenanceStatusResponse = getDomainMaintenanceStatus(GetDomainMaintenanceStatusRequest.Builder().apply(block).build())

/**
 * Retrieves information about an OpenSearch index including its schema and semantic enrichment configuration. Use this operation to view the current index structure and semantic search settings.
 */
public suspend inline fun OpenSearchClient.getIndex(crossinline block: GetIndexRequest.Builder.() -> Unit): GetIndexResponse = getIndex(GetIndexRequest.Builder().apply(block).build())

/**
 * Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and plugin properties (if the package is a zip plugin package). For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.getPackageVersionHistory(crossinline block: GetPackageVersionHistoryRequest.Builder.() -> Unit): GetPackageVersionHistoryResponse = getPackageVersionHistory(GetPackageVersionHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
 */
public suspend inline fun OpenSearchClient.getUpgradeHistory(crossinline block: GetUpgradeHistoryRequest.Builder.() -> Unit): GetUpgradeHistoryResponse = getUpgradeHistory(GetUpgradeHistoryRequest.Builder().apply(block).build())

/**
 * Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch Service domain.
 */
public suspend inline fun OpenSearchClient.getUpgradeStatus(crossinline block: GetUpgradeStatusRequest.Builder.() -> Unit): GetUpgradeStatusResponse = getUpgradeStatus(GetUpgradeStatusRequest.Builder().apply(block).build())

/**
 * Lists all OpenSearch applications under your account.
 */
public suspend inline fun OpenSearchClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists direct-query data sources for a specific domain. For more information, see For more information, see [Working with Amazon OpenSearch Service direct queries with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html).
 */
public suspend inline fun OpenSearchClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Lists an inventory of all the direct query data sources that you have configured within Amazon OpenSearch Service.
 */
public suspend inline fun OpenSearchClient.listDirectQueryDataSources(crossinline block: ListDirectQueryDataSourcesRequest.Builder.() -> Unit): ListDirectQueryDataSourcesResponse = listDirectQueryDataSources(ListDirectQueryDataSourcesRequest.Builder().apply(block).build())

/**
 * A list of maintenance actions for the domain.
 */
public suspend inline fun OpenSearchClient.listDomainMaintenances(crossinline block: ListDomainMaintenancesRequest.Builder.() -> Unit): ListDomainMaintenancesResponse = listDomainMaintenances(ListDomainMaintenancesRequest.Builder().apply(block).build())

/**
 * Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
 */
public suspend inline fun OpenSearchClient.listDomainNames(crossinline block: ListDomainNamesRequest.Builder.() -> Unit): ListDomainNamesResponse = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

/**
 * Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.listDomainsForPackage(crossinline block: ListDomainsForPackageRequest.Builder.() -> Unit): ListDomainsForPackageResponse = listDomainsForPackage(ListDomainsForPackageRequest.Builder().apply(block).build())

/**
 * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
 */
public suspend inline fun OpenSearchClient.listInstanceTypeDetails(crossinline block: ListInstanceTypeDetailsRequest.Builder.() -> Unit): ListInstanceTypeDetailsResponse = listInstanceTypeDetails(ListInstanceTypeDetailsRequest.Builder().apply(block).build())

/**
 * Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.listPackagesForDomain(crossinline block: ListPackagesForDomainRequest.Builder.() -> Unit): ListPackagesForDomainResponse = listPackagesForDomain(ListPackagesForDomainRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configuration changes that are scheduled for a domain. These changes can be [service software updates](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or [blue/green Auto-Tune enhancements](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
 */
public suspend inline fun OpenSearchClient.listScheduledActions(crossinline block: ListScheduledActionsRequest.Builder.() -> Unit): ListScheduledActionsResponse = listScheduledActions(ListScheduledActionsRequest.Builder().apply(block).build())

/**
 * Returns all resource tags for an Amazon OpenSearch Service domain, data source, or application. For more information, see [Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
 */
public suspend inline fun OpenSearchClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
 */
public suspend inline fun OpenSearchClient.listVersions(crossinline block: ListVersionsRequest.Builder.() -> Unit): ListVersionsResponse = listVersions(ListVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
 */
public suspend inline fun OpenSearchClient.listVpcEndpointAccess(crossinline block: ListVpcEndpointAccessRequest.Builder.() -> Unit): ListVpcEndpointAccessResponse = listVpcEndpointAccess(ListVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and Region.
 */
public suspend inline fun OpenSearchClient.listVpcEndpoints(crossinline block: ListVpcEndpointsRequest.Builder.() -> Unit): ListVpcEndpointsResponse = listVpcEndpoints(ListVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
 */
public suspend inline fun OpenSearchClient.listVpcEndpointsForDomain(crossinline block: ListVpcEndpointsForDomainRequest.Builder.() -> Unit): ListVpcEndpointsForDomainResponse = listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest.Builder().apply(block).build())

/**
 * Allows you to purchase Amazon OpenSearch Service Reserved Instances.
 */
public suspend inline fun OpenSearchClient.purchaseReservedInstanceOffering(crossinline block: PurchaseReservedInstanceOfferingRequest.Builder.() -> Unit): PurchaseReservedInstanceOfferingResponse = purchaseReservedInstanceOffering(PurchaseReservedInstanceOfferingRequest.Builder().apply(block).build())

/**
 * Sets the default application to the application with the specified ARN.
 *
 *  To remove the default application, use the `GetDefaultApplicationSetting` operation to get the current default and then call the `PutDefaultApplicationSetting` with the current applications ARN and the `setAsDefault` parameter set to `false`.
 */
public suspend inline fun OpenSearchClient.putDefaultApplicationSetting(crossinline block: PutDefaultApplicationSettingRequest.Builder.() -> Unit): PutDefaultApplicationSettingResponse = putDefaultApplicationSetting(PutDefaultApplicationSettingRequest.Builder().apply(block).build())

/**
 * Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
 */
public suspend inline fun OpenSearchClient.rejectInboundConnection(crossinline block: RejectInboundConnectionRequest.Builder.() -> Unit): RejectInboundConnectionResponse = rejectInboundConnection(RejectInboundConnectionRequest.Builder().apply(block).build())

/**
 * Removes the specified set of tags from an Amazon OpenSearch Service domain, data source, or application. For more information, see [ Tagging Amazon OpenSearch Service resources](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging).
 */
public suspend inline fun OpenSearchClient.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
 */
public suspend inline fun OpenSearchClient.revokeVpcEndpointAccess(crossinline block: RevokeVpcEndpointAccessRequest.Builder.() -> Unit): RevokeVpcEndpointAccessResponse = revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or Elasticsearch process restart, or a Dashboard or Kibana restart.
 */
public suspend inline fun OpenSearchClient.startDomainMaintenance(crossinline block: StartDomainMaintenanceRequest.Builder.() -> Unit): StartDomainMaintenanceResponse = startDomainMaintenance(StartDomainMaintenanceRequest.Builder().apply(block).build())

/**
 * Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
 */
public suspend inline fun OpenSearchClient.startServiceSoftwareUpdate(crossinline block: StartServiceSoftwareUpdateRequest.Builder.() -> Unit): StartServiceSoftwareUpdateResponse = startServiceSoftwareUpdate(StartServiceSoftwareUpdateRequest.Builder().apply(block).build())

/**
 * Updates the configuration and settings of an existing OpenSearch application.
 */
public suspend inline fun OpenSearchClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates a direct-query data source. For more information, see [Working with Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
 */
public suspend inline fun OpenSearchClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration or properties of an existing direct query data source in Amazon OpenSearch Service.
 */
public suspend inline fun OpenSearchClient.updateDirectQueryDataSource(crossinline block: UpdateDirectQueryDataSourceRequest.Builder.() -> Unit): UpdateDirectQueryDataSourceResponse = updateDirectQueryDataSource(UpdateDirectQueryDataSourceRequest.Builder().apply(block).build())

/**
 * Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
 */
public suspend inline fun OpenSearchClient.updateDomainConfig(crossinline block: UpdateDomainConfigRequest.Builder.() -> Unit): UpdateDomainConfigResponse = updateDomainConfig(UpdateDomainConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing OpenSearch index schema and semantic enrichment configuration. This operation allows modification of field mappings and semantic search settings for text fields. Changes to semantic enrichment configuration will apply to newly ingested documents.
 */
public suspend inline fun OpenSearchClient.updateIndex(crossinline block: UpdateIndexRequest.Builder.() -> Unit): UpdateIndexResponse = updateIndex(UpdateIndexRequest.Builder().apply(block).build())

/**
 * Updates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
 */
public suspend inline fun OpenSearchClient.updatePackage(crossinline block: UpdatePackageRequest.Builder.() -> Unit): UpdatePackageResponse = updatePackage(UpdatePackageRequest.Builder().apply(block).build())

/**
 * Updates the scope of a package. Scope of the package defines users who can view and associate a package.
 */
public suspend inline fun OpenSearchClient.updatePackageScope(crossinline block: UpdatePackageScopeRequest.Builder.() -> Unit): UpdatePackageScopeResponse = updatePackageScope(UpdatePackageScopeRequest.Builder().apply(block).build())

/**
 * Reschedules a planned domain configuration change for a later time. This change can be a scheduled [service software update](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or a [blue/green Auto-Tune enhancement](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
 */
public suspend inline fun OpenSearchClient.updateScheduledAction(crossinline block: UpdateScheduledActionRequest.Builder.() -> Unit): UpdateScheduledActionResponse = updateScheduledAction(UpdateScheduledActionRequest.Builder().apply(block).build())

/**
 * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
 */
public suspend inline fun OpenSearchClient.updateVpcEndpoint(crossinline block: UpdateVpcEndpointRequest.Builder.() -> Unit): UpdateVpcEndpointResponse = updateVpcEndpoint(UpdateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
 */
public suspend inline fun OpenSearchClient.upgradeDomain(crossinline block: UpgradeDomainRequest.Builder.() -> Unit): UpgradeDomainResponse = upgradeDomain(UpgradeDomainRequest.Builder().apply(block).build())
