// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.PackageConfiguration
import aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions
import aws.sdk.kotlin.services.opensearch.model.PackageSource
import aws.sdk.kotlin.services.opensearch.model.UpdatePackageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdatePackageOperationSerializer: HttpSerializer.NonStreaming<UpdatePackageRequest> {
    override fun serialize(context: ExecutionContext, input: UpdatePackageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/2021-01-01/packages/update"
        }

        val payload = serializeUpdatePackageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdatePackageOperationBody(context: ExecutionContext, input: UpdatePackageRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMMITMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CommitMessage"))
    val PACKAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageConfiguration"))
    val PACKAGEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PackageDescription"))
    val PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageEncryptionOptions"))
    val PACKAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PackageID"))
    val PACKAGESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PackageSource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITMESSAGE_DESCRIPTOR)
        field(PACKAGECONFIGURATION_DESCRIPTOR)
        field(PACKAGEDESCRIPTION_DESCRIPTOR)
        field(PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR)
        field(PACKAGEID_DESCRIPTOR)
        field(PACKAGESOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.commitMessage?.let { field(COMMITMESSAGE_DESCRIPTOR, it) }
        input.packageConfiguration?.let { field(PACKAGECONFIGURATION_DESCRIPTOR, it, ::serializePackageConfigurationDocument) }
        input.packageDescription?.let { field(PACKAGEDESCRIPTION_DESCRIPTOR, it) }
        input.packageEncryptionOptions?.let { field(PACKAGEENCRYPTIONOPTIONS_DESCRIPTOR, it, ::serializePackageEncryptionOptionsDocument) }
        input.packageId?.let { field(PACKAGEID_DESCRIPTOR, it) }
        input.packageSource?.let { field(PACKAGESOURCE_DESCRIPTOR, it, ::serializePackageSourceDocument) }
    }
    return serializer.toByteArray()
}
