// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSourceType
import aws.sdk.kotlin.services.opensearch.model.UpdateDirectQueryDataSourceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDirectQueryDataSourceOperationSerializer: HttpSerializer.NonStreaming<UpdateDirectQueryDataSourceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDirectQueryDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.dataSourceName) { "dataSourceName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-01-01"))
                add(PercentEncoding.Path.encode("opensearch"))
                add(PercentEncoding.Path.encode("directQueryDataSource"))
                add(PercentEncoding.SmithyLabel.encode(input.dataSourceName))
            }
        }

        val payload = serializeUpdateDirectQueryDataSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDirectQueryDataSourceOperationBody(context: ExecutionContext, input: UpdateDirectQueryDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATASOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSourceType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val OPENSEARCHARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OpenSearchArns"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCETYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(OPENSEARCHARNS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dataSourceType?.let { field(DATASOURCETYPE_DESCRIPTOR, it, ::serializeDirectQueryDataSourceTypeDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.openSearchArns != null) {
            listField(OPENSEARCHARNS_DESCRIPTOR) {
                for (el0 in input.openSearchArns) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
