// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AppConfig
import aws.sdk.kotlin.services.opensearch.model.DataSource
import aws.sdk.kotlin.services.opensearch.model.UpdateApplicationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateApplicationOperationSerializer: HttpSerializer.NonStreaming<UpdateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-01-01"))
                add(PercentEncoding.Path.encode("opensearch"))
                add(PercentEncoding.Path.encode("application"))
                add(PercentEncoding.SmithyLabel.encode(input.id))
            }
        }

        val payload = serializeUpdateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApplicationOperationBody(context: ExecutionContext, input: UpdateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("appConfigs"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPCONFIGS_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.appConfigs != null) {
            listField(APPCONFIGS_DESCRIPTOR) {
                for (el0 in input.appConfigs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAppConfigDocument))
                }
            }
        }
        if (input.dataSources != null) {
            listField(DATASOURCES_DESCRIPTOR) {
                for (el0 in input.dataSources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDataSourceDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
