// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.CompatibleVersionsMap
import aws.sdk.kotlin.services.opensearch.model.GetCompatibleVersionsResponse
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetCompatibleVersionsOperationDeserializer: HttpDeserializer.NonStreaming<GetCompatibleVersionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetCompatibleVersionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCompatibleVersionsError(context, call, payload)
        }
        val builder = GetCompatibleVersionsResponse.Builder()

        if (payload != null) {
            deserializeGetCompatibleVersionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetCompatibleVersionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCompatibleVersionsOperationBody(builder: GetCompatibleVersionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPATIBLEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleVersions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPATIBLEVERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPATIBLEVERSIONS_DESCRIPTOR.index -> builder.compatibleVersions =
                    deserializer.deserializeList(COMPATIBLEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CompatibleVersionsMap>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCompatibleVersionsMapDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
