// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.AppConfig
import aws.sdk.kotlin.services.opensearch.model.ApplicationStatus
import aws.sdk.kotlin.services.opensearch.model.DataSource
import aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse
import aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetApplicationOperationDeserializer: HttpDeserializer.NonStreaming<GetApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetApplicationError(context, call, payload)
        }
        val builder = GetApplicationResponse.Builder()

        if (payload != null) {
            deserializeGetApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetApplicationOperationBody(builder: GetApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("appConfigs"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endpoint"))
    val IAMIDENTITYCENTEROPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iamIdentityCenterOptions"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPCONFIGS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(IAMIDENTITYCENTEROPTIONS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPCONFIGS_DESCRIPTOR.index -> builder.appConfigs =
                    deserializer.deserializeList(APPCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AppConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAppConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASOURCES_DESCRIPTOR.index -> builder.dataSources =
                    deserializer.deserializeList(DATASOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<DataSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                IAMIDENTITYCENTEROPTIONS_DESCRIPTOR.index -> builder.iamIdentityCenterOptions = deserializeIamIdentityCenterOptionsDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ApplicationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
