// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.DescribeDryRunProgressResponse
import aws.sdk.kotlin.services.opensearch.model.DomainStatus
import aws.sdk.kotlin.services.opensearch.model.DryRunProgressStatus
import aws.sdk.kotlin.services.opensearch.model.DryRunResults
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeDryRunProgressOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDryRunProgressResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDryRunProgressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDryRunProgressError(context, call, payload)
        }
        val builder = DescribeDryRunProgressResponse.Builder()

        if (payload != null) {
            deserializeDescribeDryRunProgressOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDryRunProgressError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDryRunProgressOperationBody(builder: DescribeDryRunProgressResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DRYRUNCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DryRunConfig"))
    val DRYRUNPROGRESSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DryRunProgressStatus"))
    val DRYRUNRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DryRunResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DRYRUNCONFIG_DESCRIPTOR)
        field(DRYRUNPROGRESSSTATUS_DESCRIPTOR)
        field(DRYRUNRESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DRYRUNCONFIG_DESCRIPTOR.index -> builder.dryRunConfig = deserializeDomainStatusDocument(deserializer)
                DRYRUNPROGRESSSTATUS_DESCRIPTOR.index -> builder.dryRunProgressStatus = deserializeDryRunProgressStatusDocument(deserializer)
                DRYRUNRESULTS_DESCRIPTOR.index -> builder.dryRunResults = deserializeDryRunResultsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
