// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.serde

import aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse
import aws.sdk.kotlin.services.opensearch.model.DomainHealth
import aws.sdk.kotlin.services.opensearch.model.DomainState
import aws.sdk.kotlin.services.opensearch.model.EnvironmentInfo
import aws.sdk.kotlin.services.opensearch.model.MasterNodeStatus
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeDomainHealthOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDomainHealthResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDomainHealthResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDomainHealthError(context, call, payload)
        }
        val builder = DescribeDomainHealthResponse.Builder()

        if (payload != null) {
            deserializeDescribeDomainHealthOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDomainHealthError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDomainHealthOperationBody(builder: DescribeDomainHealthResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVEAVAILABILITYZONECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActiveAvailabilityZoneCount"))
    val AVAILABILITYZONECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneCount"))
    val CLUSTERHEALTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ClusterHealth"))
    val DATANODECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataNodeCount"))
    val DEDICATEDMASTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DedicatedMaster"))
    val DOMAINSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DomainState"))
    val ENVIRONMENTINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EnvironmentInformation"))
    val MASTERELIGIBLENODECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MasterEligibleNodeCount"))
    val MASTERNODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MasterNode"))
    val STANDBYAVAILABILITYZONECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StandByAvailabilityZoneCount"))
    val TOTALSHARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TotalShards"))
    val TOTALUNASSIGNEDSHARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TotalUnAssignedShards"))
    val WARMNODECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WarmNodeCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVEAVAILABILITYZONECOUNT_DESCRIPTOR)
        field(AVAILABILITYZONECOUNT_DESCRIPTOR)
        field(CLUSTERHEALTH_DESCRIPTOR)
        field(DATANODECOUNT_DESCRIPTOR)
        field(DEDICATEDMASTER_DESCRIPTOR)
        field(DOMAINSTATE_DESCRIPTOR)
        field(ENVIRONMENTINFORMATION_DESCRIPTOR)
        field(MASTERELIGIBLENODECOUNT_DESCRIPTOR)
        field(MASTERNODE_DESCRIPTOR)
        field(STANDBYAVAILABILITYZONECOUNT_DESCRIPTOR)
        field(TOTALSHARDS_DESCRIPTOR)
        field(TOTALUNASSIGNEDSHARDS_DESCRIPTOR)
        field(WARMNODECOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVEAVAILABILITYZONECOUNT_DESCRIPTOR.index -> builder.activeAvailabilityZoneCount = deserializeString()
                AVAILABILITYZONECOUNT_DESCRIPTOR.index -> builder.availabilityZoneCount = deserializeString()
                CLUSTERHEALTH_DESCRIPTOR.index -> builder.clusterHealth = deserializeString().let { DomainHealth.fromValue(it) }
                DATANODECOUNT_DESCRIPTOR.index -> builder.dataNodeCount = deserializeString()
                DEDICATEDMASTER_DESCRIPTOR.index -> builder.dedicatedMaster = deserializeBoolean()
                DOMAINSTATE_DESCRIPTOR.index -> builder.domainState = deserializeString().let { DomainState.fromValue(it) }
                ENVIRONMENTINFORMATION_DESCRIPTOR.index -> builder.environmentInformation =
                    deserializer.deserializeList(ENVIRONMENTINFORMATION_DESCRIPTOR) {
                        val col0 = mutableListOf<EnvironmentInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEnvironmentInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MASTERELIGIBLENODECOUNT_DESCRIPTOR.index -> builder.masterEligibleNodeCount = deserializeString()
                MASTERNODE_DESCRIPTOR.index -> builder.masterNode = deserializeString().let { MasterNodeStatus.fromValue(it) }
                STANDBYAVAILABILITYZONECOUNT_DESCRIPTOR.index -> builder.standByAvailabilityZoneCount = deserializeString()
                TOTALSHARDS_DESCRIPTOR.index -> builder.totalShards = deserializeString()
                TOTALUNASSIGNEDSHARDS_DESCRIPTOR.index -> builder.totalUnAssignedShards = deserializeString()
                WARMNODECOUNT_DESCRIPTOR.index -> builder.warmNodeCount = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
