// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the request parameters to the `UpgradeDomain` operation.
 */
public class UpgradeDomainRequest private constructor(builder: Builder) {
    /**
     * Only supports the `override_main_response_version` parameter and not other advanced options. You can only include this option when upgrading to an OpenSearch version. Specifies whether the domain reports its version as 7.10 so that it continues to work with Elasticsearch OSS clients and plugins.
     */
    public val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * Name of the OpenSearch Service domain that you want to upgrade.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
     */
    public val performCheckOnly: kotlin.Boolean? = builder.performCheckOnly
    /**
     * OpenSearch or Elasticsearch version to which you want to upgrade, in the format Opensearch_X.Y or Elasticsearch_X.Y.
     */
    public val targetVersion: kotlin.String? = builder.targetVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeDomainRequest(")
        append("advancedOptions=$advancedOptions,")
        append("domainName=$domainName,")
        append("performCheckOnly=$performCheckOnly,")
        append("targetVersion=$targetVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedOptions?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (performCheckOnly?.hashCode() ?: 0)
        result = 31 * result + (targetVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeDomainRequest

        if (advancedOptions != other.advancedOptions) return false
        if (domainName != other.domainName) return false
        if (performCheckOnly != other.performCheckOnly) return false
        if (targetVersion != other.targetVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Only supports the `override_main_response_version` parameter and not other advanced options. You can only include this option when upgrading to an OpenSearch version. Specifies whether the domain reports its version as 7.10 so that it continues to work with Elasticsearch OSS clients and plugins.
         */
        public var advancedOptions: Map<String, String>? = null
        /**
         * Name of the OpenSearch Service domain that you want to upgrade.
         */
        public var domainName: kotlin.String? = null
        /**
         * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
         */
        public var performCheckOnly: kotlin.Boolean? = null
        /**
         * OpenSearch or Elasticsearch version to which you want to upgrade, in the format Opensearch_X.Y or Elasticsearch_X.Y.
         */
        public var targetVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest) : this() {
            this.advancedOptions = x.advancedOptions
            this.domainName = x.domainName
            this.performCheckOnly = x.performCheckOnly
            this.targetVersion = x.targetVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = UpgradeDomainRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
